ORCA/M Asm65816 2.1.0

0001 D8F0              *******************************************************************************
0002 D8F0              *
0003 D8F0              * File: APTALK
0004 D8F0              *
0005 D8F0              * This file contains the 65816 implementation of DDP for the Apple IIGS.
0006 D8F0              *
0007 D8F0              * Copyright Apple Computer, 1986
0008 D8F0              * Original Author: Ed Lai, Greg Seitz
0009 D8F0              *
0010 D8F0              *******************************************************************************
0011 D8F0              *
0012 D8F0              * Modification History
0013 D8F0              *
0014 D8F0              * 8/8/88    TGH   - Started working on RevD ROM
0015 D8F0              *
0016 D8F0              *
0017 D8F0              *
0018 D8F0              *******************************************************************************
0019 D8F0
0020 D8F0                       MACHINE M65816 
0021 D8F0                       PRINT GEN 
0022 D8F0
0023 D8F0              *        org CodeBank+$343A             ;Old ROM location
0024 D8F0              *        keep /ram4/lib/aptalk          ;Old assembler directive
0025 D8F0
0026 D8F0                       IMPORT ADispatch 
0027 D8F0                       IMPORT GoComp 
0028 D8F0                       IMPORT LAPRead 
0029 D8F0                       IMPORT lattachprot 
0030 D8F0                       IMPORT lforbid 
0031 D8F0                       IMPORT lpermit 
0032 D8F0                       IMPORT restoreZP 
0033 D8F0                       IMPORT saveZP 
0034 D8F0
0035 D8F0                       ENTRY AddName 
0036 D8F0                       ENTRY DoWrtDDP 
0037 D8F0                       ENTRY GetName 
0038 D8F0              ;        ENTRY NBPlisten
0039 D8F0              ;        ENTRY RTMPTimer
0040 D8F0              ;        ENTRY RTMPlisten
0041 D8F0                       ENTRY calcleng 
0042 D8F0                       ENTRY calclng1 
0043 D8F0                       ENTRY calcnmln 
0044 D8F0              ;        ENTRY checkvalidentity
0045 D8F0                       ENTRY discard 
0046 D8F0                       ENTRY getlisten 
0047 D8F0              ;        ENTRY nbperror
0048 D8F0                       entry checkvalidtype 
0049 D8F0
0050 D8F0              ;-------------------------------------------------------------------------------
0051 D8F0              ;                   Global Equates 
0052 D8F0              ;-------------------------------------------------------------------------------
0053 D8F0
0054 D8F0              CodeBank equ   $ff0000
0055 D8F0              ramdata  equ   $E1D000
0056 D8F0
0057 D8F0              ;-------------------------------------------------------------------------------
0058 D8F0              ;                   General ZP usage
0059 D8F0              ;-------------------------------------------------------------------------------
0060 D8F0
0061 D8F0              cmndlist equ   $80
0062 D8F0              execaddr equ   cmndlist+4
0063 D8F0              zpCurBuf equ   execaddr+4
0064 D8F0
0065 D8F0              ;-------------------------------------------------------------------------------
0066 D8F0              ;                   DDP parameters
0067 D8F0              ;-------------------------------------------------------------------------------
0068 D8F0
0069 D8F0              ldlength equ   0
0070 D8F0              ldchksum equ   2
0071 D8F0              lddnet   equ   4
0072 D8F0              ldsnet   equ   6
0073 D8F0              lddnode  equ   8
0074 D8F0              ldsnode  equ   9
0075 D8F0              lddsckt  equ   10
0076 D8F0              ldssckt  equ   11
0077 D8F0              ldprotocol equ   12
0078 D8F0              buf_len  equ   2
0079 D8F0              buf_cksum equ   4
0080 D8F0              buf_dest equ   6
0081 D8F0              buf_data equ   9
0082 D8F0
0083 D8F0              ;-------------------------------------------------------------------------------
0084 D8F0              ;                   Common RAM usage
0085 D8F0              ;-------------------------------------------------------------------------------
0086 D8F0
0087 D8F0              lapdest  equ   CodeBank+$D000           ; packet header info
0088 D8F0              lapsrce  equ   lapdest+1
0089 D8F0              lapprot  equ   lapsrce+1
0090 D8F0              ddphead  equ   lapprot+1
0091 D8F0              thisnet  equ   ddphead+13               ; this network number
0092 D8F0              ourNode  equ   thisnet+2                ; this node number
0093 D8F0              abridge  equ   OurNode+1                ; bridge node number
0094 D8F0              tmpNBPPtr equ   abridge+1               ; pointer to buffer, pass from DDP to NBP
0095 D8F0              DDPRAM   equ   tmpNBPPtr+2
0096 D8F0
0097 D8F0              ;-------------------------------------------------------------------------------
0098 D8F0              ;                   Commands for other modules
0099 D8F0              ;-------------------------------------------------------------------------------
0100 D8F0
0101 D8F0              LapWrtCmd equ   $0700
0102 D8F0              InstTimCmd equ   $0480
0103 D8F0              RmvTimCmd equ   $0500
0104 D8F0              OpnSktCmd equ   $0B00
0105 D8F0              CnclTmCmd equ   $4500
0106 D8F0
0107 D8F0              ;-------------------------------------------------------------------------------
0108 D8F0              ;
0109 D8F0              ; Equates from procedure WriteDDP
0110 D8F0              ;
0111 D8F0              ;-------------------------------------------------------------------------------
0112 D8F0
0113 D8F0              ;
0114 D8F0              ; RAM usage
0115 D8F0              ;
0116 D8F0              wddphead equ   DDPRAM
0117 D8F0              ;
0118 D8F0              wdlapcmnd equ   wddphead+13             ; write lap command
0119 D8F0              wdlaprslt equ   wdlapcmnd+2
0120 D8F0              wdlapdest equ   wdlaprslt+2
0121 D8F0              wdlaptype equ   wdlapdest+1
0122 D8F0              wdlapwds equ   wdlaptype+1
0123 D8F0              wdddpmax equ   wdlapwds+4
0124 D8F0              ;
0125 D8F0              tempnet  equ   wdddpmax+2               ; temp area for RTMP
0126 D8F0              bridgebit equ   tempnet+2
0127 D8F0              tempbridge equ   bridgebit+1
0128 D8F0              ;
0129 D8F0              lastIndex equ   tempbridge+1            ; socket listener table
0130 D8F0              listentable equ   lastIndex+2
0131 D8F0              dynamtable equ   listentable+512
0132 D8F0              ;
0133 D8F0              RTMPTmCmd equ   dynamtable+512          ; RTMP timer
0134 D8F0              RTMPTmTsk equ   RTMPTmCmd+4
0135 D8F0              RTMPTmTimer equ   RTMPTmTsk+6
0136 D8F0              RTMPEnd  equ   RTMPTmTimer+6
0137 D8F0
0138 D8F0              ;-------------------------------------------------------------------------------
0139 D8F0              ;
0140 D8F0              ; Equates for NBP
0141 D8F0              ;
0142 D8F0              ;-------------------------------------------------------------------------------
0143 D8F0
0144 D8F0              ; RAM usage for NBP
0145 D8F0
0146 D8F0              nbpwrarea equ   RTMPEnd                 ; DDP parameter for NBP lookup
0147 D8F0              nbpchksmf equ   nbpwrarea
0148 D8F0              nbpdnet  equ   nbpchksmf+1
0149 D8F0              nbpdnode equ   nbpdnet+2
0150 D8F0              nbpdsckt equ   nbpdnode+1
0151 D8F0              nbpssckt equ   nbpdsckt+1
0152 D8F0              nbpprot  equ   nbpssckt+1
0153 D8F0              nbpwrtab equ   nbpprot+1
0154 D8F0              outnbp   equ   nbpwrtab+4               ; lkup with 1 tuple
0155 D8F0              outnbpid equ   outnbp+1                 ; NBP ID to identify transaction
0156 D8F0              nbpentity equ   outnbpid+1              ; entity during lookup
0157 D8F0              nbpptrsave equ   nbpentity+5            ; current active NBP command
0158 D8F0              nbpwds   equ   nbpptrsave+4             ; wds for reply
0159 D8F0              entitylen equ   nbpwds+12               ; part of wds that points to entity name
0160 D8F0              entityadr equ   entitylen+2
0161 D8F0              nbpwdsend equ   entityadr+4             ; wds end flag (should be FFFF)
0162 D8F0              tuplect  equ   nbpwdsend+2              ; number of tuples in packet
0163 D8F0              NBPTmCmd equ   tuplect+1                ; NBP timer
0164 D8F0              NBPTmTsk equ   NBPTmCmd+4
0165 D8F0              NBPTmTime equ   NBPTmTsk+6
0166 D8F0              namelist equ   NBPTmTime+6              ; list head for registered name
0167 D8F0              rptupcount equ   namelist+4             ; NBP header during reply
0168 D8F0              replyNID equ   rptupcount+1
0169 D8F0              nbprptable equ   replyNID+1             ; 4 tuples, 1 empty 1 NID + FFFF marker
0170 D8F0              NBPEnd   equ   nbprptable+38
0171 D8F0
0172 D8F0              ; command number
0173 D8F0
0174 D8F0              NBPREGN  equ   $0E                      ; name register
0175 D8F0              NBPLKUP  equ   $10                      ; name look up
0176 D8F0              NBPCFRM  equ   $11                      ; name reply
0177 D8F0
0178 D8F0              ; parameters
0179 D8F0
0180 D8F0              CmEntAdr equ   8
0181 D8F0              CmTimOut equ   12
0182 D8F0              CmRetry  equ   13
0183 D8F0              CmTimLft equ   14
0184 D8F0              CMTryLft equ   15
0185 D8F0              CmRsbSiz equ   16                       ; for look up, buffer size
0186 D8F0              CmRsbAdr equ   18
0187 D8F0              CmMaxrsp equ   22
0188 D8F0              CmRspCnt equ   23
0189 D8F0              CmCfmNet equ   16                       ; for confirm, network number
0190 D8F0              CmCfmNode equ   18
0191 D8F0              CmCfmSckt equ   19
0192 D8F0              CmCfmActSkt equ   20
0193 D8F0              CmRegSkt equ   16                       ; for register, socket number
0194 D8F0              CmSetIt  equ   17                       ; if nonzero, don't check name
0195 D8F0              CmRmvEntity equ   4
0196 D8F0
0197 D8F0              ; ZP usage
0198 D8F0
0199 D8F0              tblptr   equ   cmndlist+4
0200 D8F0              nbpbfptr equ   cmndlist+8
0201 D8F0              nbprcvct equ   cmndlist+12
0202 D8F0              nameleng equ   cmndlist+12
0203 D8F0              regsckt  equ   cmndlist+12
0204 D8F0              regenum  equ   cmndlist+13
0205 D8F0              nbptbdisp equ   cmndlist+11
0206 D8F0              tempy1   equ   cmndlist+12
0207 D8F0              tempy2   equ   cmndlist+13
0208 D8F0              tempChar equ   cmndlist+3
0209 D8F0
0210 D8F0              ; errors
0211 D8F0
0212 D8F0              toomanynames equ   $401
0213 D8F0              duplname equ   $402
0214 D8F0              wrongName equ   $403
0215 D8F0              buffull  equ   $404
0216 D8F0              badName  equ   $406
0217 D8F0              diffsckt equ   $407
0218 D8F0              manyNBP  equ   $408
0219 D8F0              NBPaborted equ   $409
0220 D8F0              BadParamBlock equ   $40A
0221 D8F0
0222 D8F0              ;_______________________________________________________________________________
0223 D8F0
0224 D8F0              DDPWrite PROC EXPORT 
0225 D8F0
0226 D8F0              ; ZP equs
0227 D8F0
0228 D8F0              wdsadr   equ   cmndlist+4
0229 D8F0              databuf  equ   cmndlist+8
0230 D8F0              wdchksmf equ   cmndlist+11
0231 D8F0              tmpcksum equ   cmndlist+12
0232 D8F0
0233 D8F0              ; paramters in write DDP
0234 D8F0
0235 D8F0              CmChkSum equ   4
0236 D8F0              CmDstNet equ   5
0237 D8F0              CmDstNode equ   7
0238 D8F0              CmDstSckt equ   8
0239 D8F0              CmSrcSckt equ   9
0240 D8F0              CmProtTyp equ   10
0241 D8F0              CmWDS    equ   11
0242 D8F0
0243 D8F0
0244 D8F0              ; the following constant is incorrect in the rom, it has a bad value of 587 so we need
0245 D8F0              ; to patch the write routine to get the correct value.
0246 D8F0              ; This has been fixed in ROM 2.
0247 D8F0
0248 D8F0              maxDDPp1 equ   600                      ; max number of bytes in long DDP packet + 1
0249 D8F0              maxDDPps equ   592                      ; max number of bytes in short DDP packet + 1
0250 D8F0
0251 D8F0              ; error equs   
0252 D8F0
0253 D8F0              tablefull equ   $301
0254 D8F0              scktnotopen equ   $302
0255 D8F0              socketopen equ   $303
0256 D8F0              badsocket equ   $304
0257 D8F0              largeDDP equ   $305
0258 D8F0              nobridge equ   $306
0259 D8F0
0260 D8F0              sdlength equ   0
0261 D8F0              sddsckt  equ   2
0262 D8F0              sdssckt  equ   3
0263 D8F0              sdprotocol equ   4
0264 D8F0
0265 D8F0              ;...............................................................
0266 D8F0              ;
0267 D8F0              ; Write DDP packet, use command list
0268 D8F0              ;
0269 D8F0              ;...............................................................
0270 D8F0
0271 D8F0                       IS16BIT 
0272 D8F0 A0 0A 00              ldy   #CmProtTyp
0273 D8F3 B7 80                 lda   [cmndlist],y
0274 D8F5 29 FF 00              and   #$00ff                   ; only want 1 byte
0275 D8F8 D0 05                 bne   ddpwrite1                ; not zero, so valid
0276 D8FA A9 04 03              lda   #badsocket               ; report the error
0277 D8FD 80 25                 bra   wderr_1
0278 D8FF              ddpwrite1                               ; 
0279 D8FF A0 08 00              ldy   #CmDstSckt
0280 D902 B7 80                 lda   [cmndlist],y             ; get destination socket
0281 D904 20 2A D9              jsr   checkvalidtype           ; see if it is ok
0282 D907 B0 1B                 bcs   wderr_1                  ; no it isn't
0283 D909 A0 09 00              ldy   #CmSrcSckt
0284 D90C B7 80                 lda   [cmndlist],y
0285 D90E 20 2A D9              jsr   checkvalidtype           ; see if it is ok
0286 D911 B0 11                 bcs   wderr_1                  ; no it isn't
0287 D913 20 27 DB              jsr   getlisten                ; is socket open ?
0288 D916 F0 09                 beq   wderr                    ; socket not found
0289 D918 A6 80                 ldx   cmndlist
0290 D91A A4 82                 ldy   cmndlist+2
0291 D91C 20 3B D9              jsr   DoWrtDDP
0292 D91F 80 03                 bra   wderr_1
0293 D921 A9 02 03     wderr    lda   #scktnotopen             ; else error
0294 D924 A0 02 00     wderr_1  ldy   #2
0295 D927 97 80                 sta   [cmndlist],y
0296 D929 6B                    rtl   
0297 D92A
0298 D92A              ;...............................................................
0299 D92A              ;
0300 D92A              ; checkvalidtype
0301 D92A              ; checks the socket passed in the low
0302 D92A              ; byte of the accumulator to see if it
0303 D92A              ; is in the valid range
0304 D92A              ; 
0305 D92A              ; returns carry clear if it is ok
0306 D92A              ; returns with carry set and error in accum if not ok
0307 D92A              ;
0308 D92A              ;...............................................................
0309 D92A
0310 D92A                       entry checkvalidtype           ;EXPORT -> ENTRY **TGH
0311 D92A              checkvalidtype  
0312 D92A 29 FF 00              and   #$00ff
0313 D92D F0 07                 beq   @checkfail               ; the check failed
0314 D92F C9 FF 00              cmp   #$00ff                   ; see if $ff
0315 D932 F0 02                 beq   @checkfail               ; yes, so set error code an leave
0316 D934 18                    clc                            ; no error
0317 D935 60                    rts   
0318 D936 38           @checkfail sec                          ; an error occurred
0319 D937 A9 04 03              lda   #badsocket               ; so return invalid socket type
0320 D93A 60                    rts   
0321 D93B
0322 D93B              ;
0323 D93B              ;...............................................................
0324 D93B              ;
0325 D93B              ;  Internal write DDP routine, (Y,X) points to command list
0326 D93B              ;    result returns in Acc
0327 D93B              ;
0328 D93B              ;...............................................................
0329 D93B
0330 D93B                       IS16BIT 
0331 D93B                       entry DoWrtDDP                 ;EXPORT -> ENTRY **TGH
0332 D93B              DoWrtDDP                                ;       ; make a ddp packet and write it out
0333 D93B 86 88                 stx   databuf
0334 D93D 84 8A                 sty   databuf+2
0335 D93F 20 B8 F9              jsr   lforbid
0336 D942 E2 10                 _16BIT16M 
0337 D944 A0 0B                 ldy   #CmWds
0338 D946 B7 88                 lda   [databuf],y
0339 D948 85 84                 sta   wdsadr
0340 D94A 8D 29 D0              sta   |wdlapwds
0341 D94D A0 0D                 ldy   #CmWds+2
0342 D94F B7 88                 lda   [databuf],y
0343 D951 85 86                 sta   wdsadr+2
0344 D953 8D 2B D0              sta   |wdlapwds+2
0345 D956 A0 05                 ldy   #CmDstNet
0346 D958 B7 88                 lda   [databuf],y              ; get newtwork #
0347 D95A F0 05                 beq   wrtshort                 ; 0 is local
0348 D95C CD 10 D0              cmp   |thisnet
0349 D95F D0 36                 bne   wrtlong                  ; another net
0350 D961 A9 05 00     wrtshort lda   #5                       ; short DDP header is 5 byte
0351 D964 87 84                 sta   [wdsadr]
0352 D966 EB                    xba                            ; reverse of 6502 convention 
0353 D967 8D 16 D0              sta   |wddphead+sdlength
0354 D96A A9 50 02              lda   #maxDDPps                ; get max short packet size
0355 D96D 8D 2D D0              sta   |wdddpmax                ; and save for later compare
0356 D970 E2 30                 USE8BIT 
0357 D972 A0 07                 ldy   #CmDstNode
0358 D974 B7 88                 lda   [databuf],y
0359 D976 8D 27 D0              sta   |wdlapdest
0360 D979 C8                    iny   
0361 D97A B7 88                 lda   [databuf],y
0362 D97C 8D 18 D0              sta   |wddphead+sddsckt
0363 D97F A0 09                 ldy   #CmSrcSckt
0364 D981 B7 88                 lda   [databuf],y
0365 D983 8D 19 D0              sta   |wddphead+sdssckt
0366 D986 C8                    iny   
0367 D987 B7 88                 lda   [databuf],y
0368 D989 8D 1A D0              sta   |wddphead+sdprotocol
0369 D98C A2 01                 ldx   #1
0370 D98E 8E 28 D0              stx   |wdlaptype               ; short ddp is type 1
0371 D991 64 8B                 stz   wdchksmf                 ; never do checksum on short ddp
0372 D993 C2 20                 USE16M 
0373 D995 80 7A                 bra   wddp_2
0374 D997 A9 0D 00     wrtlong  lda   #13                      ; long atp header is 13 bytes
0375 D99A 87 84                 sta   [wdsadr]
0376 D99C EB                    xba                            ; reverse of 6502 convention
0377 D99D 8D 16 D0              sta   |wddphead+ldlength
0378 D9A0 A9 58 02              lda   #maxDDPp1                ; get max long packet size
0379 D9A3 8D 2D D0              sta   |wdddpmax                ; and save for later compare
0380 D9A6 A0 05                 ldy   #CmDstNet
0381 D9A8 B7 88                 lda   [databuf],y
0382 D9AA 8D 1A D0              sta   |wddphead+lddnet
0383 D9AD AD 10 D0              lda   |thisnet
0384 D9B0 8D 1C D0              sta   |wddphead+ldsnet
0385 D9B3 E2 30                 USE8BIT 
0386 D9B5 A0 07                 ldy   #CmDstNode
0387 D9B7 B7 88                 lda   [databuf],y
0388 D9B9 8D 1E D0              sta   |wddphead+lddnode
0389 D9BC C8                    iny   
0390 D9BD B7 88                 lda   [databuf],y
0391 D9BF 8D 20 D0              sta   |wddphead+lddsckt
0392 D9C2 AD 12 D0              lda   |ournode
0393 D9C5 8D 1F D0              sta   |wddphead+ldsnode
0394 D9C8 A0 09                 ldy   #CmSrcSckt
0395 D9CA B7 88                 lda   [databuf],y
0396 D9CC 8D 21 D0              sta   |wddphead+ldssckt
0397 D9CF C8                    iny   
0398 D9D0 B7 88                 lda   [databuf],y
0399 D9D2 8D 22 D0              sta   |wddphead+ldprotocol
0400 D9D5 C2 20                 USE16M 
0401 D9D7 A2 02                 ldx   #2
0402 D9D9 8E 28 D0              stx   |wdlaptype               ; long ddp is protocol 2
0403 D9DC 9C 18 D0              stz   |wddphead+ldchksum       ; assume no checksum
0404 D9DF A0 04                 ldy   #CmChkSum
0405 D9E1 B7 88                 lda   [databuf],y
0406 D9E3 AA                    tax                            ; make into 8 bits
0407 D9E4 86 8B                 stx   wdchksmf
0408 D9E6 F0 11                 beq   wddp_0
0409 D9E8 A9 1A D0              lda   #wddphead+4
0410 D9EB 85 88                 sta   databuf                  ; calculate checksum of ddp header
0411 D9ED A2 E1                 ldx   #^ramdata
0412 D9EF 86 8A                 stx   databuf+2
0413 D9F1 64 8C                 stz   tmpcksum
0414 D9F3 A9 09 00              lda   #9
0415 D9F6 20 7F DA              jsr   calcchksum
0416 D9F9 AD 10 D0     wddp_0   lda   |thisnet                 ; do we have a netwokr # ?
0417 D9FC F0 0D                 beq   wddp_1a                  ; no, send to node  
0418 D9FE AE 13 D0              ldx   |abridge                 ; do we have a bridge
0419 DA01 D0 0B                 bne   wddp_1b                  ; then send it to bridge
0420 DA03 C2 30                 USE16BIT 
0421 DA05 A9 06 03              lda   #nobridge
0422 DA08 4C 7B DA              jmp   wddp_8
0423 DA0B                       IS16M 
0424 DA0B AE 1E D0     wddp_1a  ldx   |wddphead+lddnode        ; else send it to node in same net
0425 DA0E 8E 27 D0     wddp_1b  stx   |wdlapdest               ; send to bridge or node
0426 DA11 A0 02        wddp_2   ldy   #2                       ; copy our header addr to first 4 byte of wds
0427 DA13 A9 16 D0              lda   #wddphead
0428 DA16 97 84                 sta   [wdsadr],y
0429 DA18 A0 04                 ldy   #4
0430 DA1A A9 E1 00              lda   #^ramdata
0431 DA1D 97 84                 sta   [wdsadr],y
0432 DA1F 18           wddp_4   clc                            ; first adjust for size of datagram header
0433 DA20 A9 06 00              lda   #6
0434 DA23 65 84                 adc   wdsadr
0435 DA25 85 84                 sta   wdsadr
0436 DA27 A7 84                 lda   [wdsadr]
0437 DA29 30 2F                 bmi   wddp_6                   ; end of list reached
0438 DA2B 18                    clc   
0439 DA2C AD 16 D0              lda   |wddphead+sdlength
0440 DA2F EB                    xba                            ; convention is opposite of 6502
0441 DA30 67 84                 adc   [wdsadr]
0442 DA32 CD 2D D0              cmp   |wdddpmax                ; too many bytes?
0443 DA35 90 07                 blt   wddp_4A                  ; size still OK
0444 DA37 C2 30                 USE16BIT 
0445 DA39 A9 05 03              lda   #largeDDP                ; else error
0446 DA3C 80 3D                 bra   wddp_8
0447 DA3E                       IS16M 
0448 DA3E EB           wddp_4A  xba   
0449 DA3F 8D 16 D0              sta   |wddphead+sdlength
0450 DA42 A6 8B                 ldx   wdchksmf
0451 DA44 F0 D9                 beq   wddp_4                   ; no need to calculate checksum
0452 DA46 A0 02                 ldy   #2
0453 DA48 B7 84                 lda   [wdsadr],y
0454 DA4A 85 88                 sta   databuf
0455 DA4C A0 04                 ldy   #4
0456 DA4E B7 84                 lda   [wdsadr],y
0457 DA50 AA                    tax                            ; 8 bits
0458 DA51 86 8A                 stx   databuf+2                ; 24 bit address
0459 DA53 A7 84                 lda   [wdsadr]                 ; get size
0460 DA55 20 7F DA              jsr   calcchksum
0461 DA58 80 C5                 bra   wddp_4
0462 DA5A A6 8B        wddp_6   ldx   wdchksmf                 ; done with list
0463 DA5C F0 09                 beq   wddp_7                   ; no need to adjust checksum
0464 DA5E A5 8C                 lda   tmpcksum
0465 DA60 D0 01                 bne   wddp_6a
0466 DA62 3A                    dec   A                        ; if zero use $FFFF
0467 DA63 EB           wddp_6a  xba                            ; appletalk conventin opps of 6502
0468 DA64 8D 18 D0              sta   |wddphead+ldchksum
0469 DA67              wddp_7                                  ; 
0470 DA67 C2 30                 USE16BIT 
0471 DA69 A9 00 07              lda   #LapWrtCmd
0472 DA6C 8D 23 D0              sta   |wdlapcmnd
0473 DA6F A2 23 D0              ldx   #wdlapcmnd
0474 DA72 A0 E1 00              ldy   #^ramdata
0475 DA75 20 73 E4              jsr   ADispatch
0476 DA78 AD 25 D0              lda   |wdlaprslt               ; get back error
0477 DA7B 20 E0 F9     wddp_8   jsr   lpermit
0478 DA7E 60                    rts   
0479 DA7F              ;...............................................................
0480 DA7F              ;
0481 DA7F              ;  calculate checksum for a number of bytes
0482 DA7F              ;  running checksum in tmpcksum
0483 DA7F              ;  buffer point to by databuf
0484 DA7F              ;  byte count in Acc
0485 DA7F              ;...............................................................
0486 DA7F              ;
0487 DA7F                       IS16M 
0488 DA7F              calcchksum                              ; 
0489 DA7F C2 30                 USE16BIT 
0490 DA81 A0 00 00              ldy   #0
0491 DA84 AA                    tax                            ; number of bytes
0492 DA85 E8                    inx   
0493 DA86 CA           chksum_0 dex   
0494 DA87 F0 12                 beq   chksum_9
0495 DA89 B7 88                 lda   [databuf],y
0496 DA8B 29 FF 00              and   #$00FF
0497 DA8E 18                    clc   
0498 DA8F 65 8C                 adc   tmpcksum
0499 DA91 18                    clc   
0500 DA92 10 01                 bpl   chksum_1
0501 DA94 38                    sec   
0502 DA95 2A           chksum_1 rol   A
0503 DA96 85 8C                 sta   tmpcksum
0504 DA98 C8                    iny   
0505 DA99 80 EB                 bra   chksum_0
0506 DA9B              chksum_9                                ; 
0507 DA9B E2 10                 _16BIT16M 
0508 DA9D 60                    rts   
0509 DA9E
0510 DA9E              ;...............................................................
0511 DA9E              ;
0512 DA9E              ;  open a DDP socket using parameter list
0513 DA9E              ;...............................................................
0514 DA9E
0515 DA9E                       IS16BIT 
0516 DA9E
0517 DA9E              CmOSKSkt equ   4
0518 DA9E              CmOSKLst equ   5
0519 DA9E
0520 DA9E                       EXPORT openskt 
0521 DA9E              openskt                                 ;
0522 DA9E E2 30                 USE8BIT 
0523 DAA0 A0 04                 ldy   #CmOSKSkt
0524 DAA2 B7 80                 lda   [cmndlist],y
0525 DAA4 C2 30                 USE16BIT 
0526 DAA6 30 50                 bmi   opnskt_6                 ; dynamic may not be fixed
0527 DAA8 D0 29                 bne   opnskt_3                 ; well known, then try it
0528 DAAA AE 33 D0              ldx   |lastIndex               ; dynamic, generate one
0529 DAAD E8           opnskt_1 inx   
0530 DAAE E8                    inx   
0531 DAAF E8                    inx   
0532 DAB0 E8                    inx   
0533 DAB1 E0 FC 01              cpx   #127*4
0534 DAB4 90 03                 bcc   opnskt_2                 ; OK if less than max
0535 DAB6 A2 00 00              ldx   #0
0536 DAB9 EC 33 D0     opnskt_2 cpx   |lastIndex               ; did we use it all
0537 DABC F0 3F                 beq   opnskt_8                 ; yes
0538 DABE 3C 37 D2              bit   |dynamtable+2,x          ; is it occupied ?
0539 DAC1 30 EA                 bmi   opnskt_1                 ; yes, check more
0540 DAC3 8E 33 D0              stx   |lastIndex
0541 DAC6 8A                    txa   
0542 DAC7 4A                    lsr   a
0543 DAC8 4A                    lsr   a
0544 DAC9 E2 30                 USE8BIT 
0545 DACB 69 80                 adc   #$80                     ; find dynamic socket #
0546 DACD A0 04                 ldy   #CmOSKSkt
0547 DACF 97 80                 sta   [cmndlist],y
0548 DAD1 C2 30                 USE16BIT 
0549 DAD3 29 FF 00     opnskt_3 and   #$00FF
0550 DAD6 0A                    asl   a
0551 DAD7 0A                    asl   a
0552 DAD8 AA                    tax   
0553 DAD9 A9 03 03              lda   #socketopen              ; assume error
0554 DADC 3C 37 D0              bit   |listenTable+2,X         ; check if occupied for well known
0555 DADF 30 1F                 bmi   opnskt_9                 ; yes, then error
0556 DAE1 A0 05 00              ldy   #CmOSKLst
0557 DAE4 B7 80                 lda   [cmndlist],y
0558 DAE6 9D 35 D0              sta   |listentable,x
0559 DAE9 C8                    iny   
0560 DAEA C8                    iny   
0561 DAEB B7 80                 lda   [cmndlist],y
0562 DAED 09 00 80              ora   #$8000
0563 DAF0 9D 37 D0              sta   |listentable+2,x
0564 DAF3 A9 00 00              lda   #0
0565 DAF6 80 08                 bra   opnskt_9
0566 DAF8 A9 04 03     opnskt_6 lda   #badsocket
0567 DAFB 80 03                 bra   opnskt_9
0568 DAFD A9 01 03     opnskt_8 lda   #tablefull
0569 DB00 A0 02 00     opnskt_9 ldy   #2
0570 DB03 97 80                 sta   [cmndlist],y
0571 DB05 6B                    rtl   
0572 DB06
0573 DB06              ;...............................................................
0574 DB06              ;
0575 DB06              ;  close a DDP socket using parameter list
0576 DB06              ;...............................................................
0577 DB06              ;
0578 DB06
0579 DB06                       IS16BIT 
0580 DB06
0581 DB06              CmClsSkt equ   4
0582 DB06
0583 DB06                       EXPORT closeskt 
0584 DB06              closeskt                                ;       
0585 DB06 A0 04 00              ldy   #CmClsSkt
0586 DB09 B7 80                 lda   [cmndlist],y
0587 DB0B 20 2A D9              jsr   checkvalidtype           ; see if socket type is valid
0588 DB0E B0 11                 bcs   clseddp_9                ; return the error
0589 DB10 0A                    asl   a
0590 DB11 0A                    asl   a
0591 DB12 AA                    tax   
0592 DB13 A9 02 03              lda   #scktnotopen             ; assume error
0593 DB16 3C 37 D0              bit   |listenTable+2,x         ; check into table
0594 DB19 10 06                 bpl   clseddp_9                ; no entry there, error
0595 DB1B 9E 37 D0              stz   |listenTable+2,x
0596 DB1E A9 00 00     clseddp_8 lda   #0
0597 DB21 A0 02 00     clseddp_9 ldy   #2
0598 DB24 97 80                 sta   [cmndlist],y
0599 DB26 6B                    rtl   
0600 DB27              ;...............................................................
0601 DB27              ;
0602 DB27              ;  get listener address for a socket
0603 DB27              ;      socket in Acc
0604 DB27              ;      listener address return in Y,X (3 bytes only)
0605 DB27              ;      if no listener, zero flag is set
0606 DB27              ;...............................................................
0607 DB27              ;
0608 DB27                       IS16BIT 
0609 DB27
0610 DB27                       entry getlisten                ;EXPORT -> ENTRY  **TGH
0611 DB27              getlisten                               ;   
0612 DB27
0613 DB27                       EXPORT ddpcheckskt 
0614 DB27              ddpcheckskt                             ;       
0615 DB27 29 FF 00              and   #$00FF                   ; zero is illegal
0616 DB2A 0A                    asl   a
0617 DB2B 0A                    asl   a
0618 DB2C AA                    tax   
0619 DB2D 3C 37 D0              bit   |listentable+2,x
0620 DB30 10 0A                 bpl   nocontent
0621 DB32 BC 37 D0              ldy   |listentable+2,x
0622 DB35 BD 35 D0              lda   |listentable,x
0623 DB38 AA                    tax   
0624 DB39 C2 02                 rep   #02                      ; set nonzero flag
0625 DB3B 60                    rts   
0626 DB3C A2 00 00     nocontent ldx   #0                      ; empty, return NIL
0627 DB3F 9B                    txy   
0628 DB40 60                    rts   
0629 DB41              ;...............................................................
0630 DB41              ;
0631 DB41              ;  read header part of protocol into reserved memory        
0632 DB41              ;      size in Acc
0633 DB41              ;      buffer in in X
0634 DB41              ;      carry set if error
0635 DB41              ;...............................................................
0636 DB41                       IS16BIT 
0637 DB41 A0 E1 00     readheader ldy   #^ramdata
0638 DB44 38                    sec   
0639 DB45 20 D6 F5              jsr   LAPRead
0640 DB48 18                    clc   
0641 DB49 A8                    tay   
0642 DB4A F0 04                 beq   RdRts
0643 DB4C 20 51 DB              jsr   discard
0644 DB4F 38                    sec   
0645 DB50 60           RdRts    rts   
0646 DB51              ;...............................................................
0647 DB51              ;
0648 DB51              ;  discard the packet
0649 DB51              ;...............................................................
0650 DB51                       IS16BIT 
0651 DB51                       entry discard                  ;EXPORT -> ENTRY  **TGH
0652 DB51              discard                                 ;
0653 DB51 38                    sec   
0654 DB52 A9 00 80              lda   #$8000
0655 DB55 4C D6 F5              jmp   lapread
0656 DB58              ;...............................................................
0657 DB58              ;
0658 DB58              ;  protocol handler for short DDP
0659 DB58              ;...............................................................
0660 DB58                       IS16BIT 
0661 DB58
0662 DB58                       entry ShortDDP                 ;EXPORT -> ENTRY  **TGH
0663 DB58              ShortDDP                                ;
0664 DB58 20 0C DC              jsr   checkLength
0665 DB5B F0 03                 beq   sddp_0
0666 DB5D 4C 08 DC              jmp   reject_2
0667 DB60 18           sddp_0   clc   
0668 DB61 A9 0E 00              lda   #5+buf_data
0669 DB64 65 80                 adc   cmndlist
0670 DB66 8D 14 D0              sta   |tmpNBPPtr
0671 DB69 A9 05 00              lda   #5
0672 DB6C A2 03 D0              ldx   #ddphead
0673 DB6F 20 41 DB              jsr   readheader               ; read the DDP header
0674 DB72 90 01                 bcc   sddp_1
0675 DB74 6B                    rtl   
0676 DB75              sddp_1                                  ; 
0677 DB75 E2 10                 _16BIT16M 
0678 DB77 A2 01                 ldx   #1                       ; short DDP is protocol 1
0679 DB79 8E 02 D0              stx   |lapprot
0680 DB7C AD 05 D0              lda   |ddphead+sddsckt         ; since 16 bit inculde ssckt
0681 DB7F 8D 0D D0              sta   |ddphead+lddsckt         ; since 16 bit inculde ssckt
0682 DB82 AE 07 D0              ldx   |ddphead+sdprotocol
0683 DB85 8E 0F D0              stx   |ddphead+ldprotocol
0684 DB88 AE 00 D0              ldx   |lapdest
0685 DB8B 8E 0B D0              stx   |ddphead+lddnode
0686 DB8E AE 01 D0              ldx   |lapsrce
0687 DB91 8E 0C D0              stx   |ddphead+ldsnode
0688 DB94 9C 09 D0              stz   |ddphead+ldsnet          ; short ddp has zero net number
0689 DB97 9C 07 D0              stz   |ddphead+lddnet          ; ' '
0690 DB9A 9C 05 D0              stz   |ddphead+ldchksum        ; zero out the checksum on short packet
0691 DB9D 80 45                 bra   readddp
0692 DB9F              ;...............................................................
0693 DB9F              ;
0694 DB9F              ;  protocol handler for long DDP
0695 DB9F              ;...............................................................
0696 DB9F                       IS16BIT 
0697 DB9F                       entry LongDDP                  ;EXPORT -> ENTRY  **TGH
0698 DB9F              LongDDP                                 ;
0699 DB9F 20 0C DC              jsr   checkLength
0700 DBA2 D0 64                 bne   reject_2
0701 DBA4 A0 0B 00              ldy   #buf_data+ldchksum
0702 DBA7 B1 80                 lda   (cmndlist),y
0703 DBA9 F0 08                 beq   long_0
0704 DBAB EB                    xba   
0705 DBAC A0 04 00              ldy   #buf_CkSum
0706 DBAF D1 80                 cmp   (cmndlist),y
0707 DBB1 D0 55                 bne   reject_2
0708 DBB3 18           long_0   clc   
0709 DBB4 A9 16 00              lda   #13+buf_data
0710 DBB7 65 80                 adc   cmndlist
0711 DBB9 8D 14 D0              sta   |tmpNBPPtr
0712 DBBC A9 0D 00              lda   #13
0713 DBBF A2 03 D0              ldx   #ddphead
0714 DBC2 20 41 DB              jsr   readheader
0715 DBC5 B0 3E                 bcs   rddpdone                 ; if error try next packet
0716 DBC7 E2 10                 _16BIT16M 
0717 DBC9 A2 02                 ldx   #2                       ; long DDP is prot 2
0718 DBCB 8E 02 D0              stx   |lapprot
0719 DBCE AD 07 D0              lda   |ddphead+lddnet
0720 DBD1 F0 05                 beq   long_1                   ; zero match anything
0721 DBD3 CD 10 D0              cmp   |thisnet                 ; filter out wrong net
0722 DBD6 D0 2E                 bne   reject_1
0723 DBD8 AE 0B D0     long_1   ldx   |ddphead+lddnode         ; is it address to us ?
0724 DBDB EC 12 D0              cpx   |ournode
0725 DBDE F0 04                 beq   readddp
0726 DBE0 E0 FF                 cpx   #$FF                     ; is it broadcast
0727 DBE2 D0 22                 bne   reject_1
0728 DBE4 AE 0D D0     readddp  ldx   |ddphead+lddsckt         ; packet for which socket
0729 DBE7 F0 1D                 beq   reject_1                 ; type 0 not allowed
0730 DBE9 8A                    txa   
0731 DBEA C2 30                 USE16BIT 
0732 DBEC 20 27 DB              jsr   getlisten                ; search the socket table
0733 DBEF F0 17                 beq   reject_2                 ; no listener
0734 DBF1 86 84                 stx   execaddr
0735 DBF3 98                    tya   
0736 DBF4 29 FF 00              and   #$00FF                   ; mask off high byte
0737 DBF7 85 86                 sta   execaddr+2
0738 DBF9 05 84                 ora   execaddr                 ; any routine ?
0739 DBFB F0 0B                 beq   reject_2                 ; none, throw away packet
0740 DBFD A9 00 D0              lda   #lapdest
0741 DC00 85 80                 sta   cmndlist
0742 DC02 4C 8A E9              jmp   GoComp
0743 DC05 6B           rddpdone rtl   
0744 DC06              ;
0745 DC06                       IS16M 
0746 DC06              reject_1                                ; 
0747 DC06 C2 30                 USE16BIT 
0748 DC08 20 51 DB     reject_2 jsr   discard
0749 DC0B 6B                    rtl   
0750 DC0C              ;
0751 DC0C              ; make sure packet is of right length
0752 DC0C              ;
0753 DC0C              checkLength                             ; 
0754 DC0C F4 E1 E1 AB           BANK0ENTRY 
0755 DC11 A0 06 00              ldy   #buf_dest
0756 DC14 B1 80                 lda   (cmndlist),y
0757 DC16 8D 00 D0              sta   |lapdest
0758 DC19 A0 09 00              ldy   #buf_data                ; get header claim length
0759 DC1C B1 80                 lda   (cmndlist),y
0760 DC1E EB                    xba   
0761 DC1F 29 FF 03              and   #$03FF
0762 DC22 A0 02 00              ldy   #buf_len
0763 DC25 D1 80                 cmp   (cmndlist),y
0764 DC27 60                    rts   
0765 DC28              ;
0766 DC28              ;...............................................................
0767 DC28              ;
0768 DC28              ;  socket listener for RTMP
0769 DC28              ;...............................................................
0770 DC28              ;
0771 DC28                       entry RTMPlisten               ;EXPORT -> ENTRY  **TGH
0772 DC28              RTMPlisten                              ;
0773 DC28 F4 E1 E1 AB           BANK0ENTRY 
0774 DC2D AD 0F D0              lda   |ddphead+ldprotocol      ; RTMP is type 1
0775 DC30 29 FF 00              and   #$00FF
0776 DC33 C9 01 00              cmp   #1
0777 DC36 D0 4A                 bne   rtmp_8                   ; not RTMP, discard
0778 DC38 A9 04 00              lda   #4
0779 DC3B A2 2F D0              ldx   #tempnet
0780 DC3E 20 41 DB              jsr   readheader
0781 DC41 B0 42                 bcs   rtmp_9                   ; if error, already discarded
0782 DC43 E2 30                 USE8BIT 
0783 DC45 AD 31 D0              lda   |bridgebit
0784 DC48 C9 08                 cmp   #8
0785 DC4A D0 34                 bne   rtmp_7
0786 DC4C AD 32 D0              lda   |tempbridge              ; we can update bridge information
0787 DC4F 8D 13 D0              sta   |abridge
0788 DC52 C2 30                 USE16BIT 
0789 DC54 AD 2F D0              lda   |tempnet
0790 DC57 8D 10 D0              sta   |thisnet
0791 DC5A A9 D0 02              lda   #4*180                   ; we need 180 seconds since interrupts
0792 DC5D 8D 3F D4              sta   |RTMPTmTimer             ; get turned off so much...
0793 DC60 AD 35 D4              lda   |RTMPTmCmd               ; do we have a timer yet
0794 DC63 D0 1D                 bne   rtmp_8                   ; then no need to install one
0795 DC65 A9 80 04              lda   #InstTimCmd
0796 DC68 8D 35 D4              sta   |RTMPTmCmd               ; command for install
0797 DC6B A9 86 DC              lda   #RTMPTimer
0798 DC6E 8D 39 D4              sta   |RTMPTmTsk
0799 DC71 A9 FD 00              lda   #^RTMPTimer
0800 DC74 8D 3B D4              sta   |RTMPTmTsk+2
0801 DC77 A2 35 D4              ldx   #RTMPTmCmd
0802 DC7A A0 E1 00              ldy   #^ramdata
0803 DC7D 20 73 E4              jsr   ADispatch
0804 DC80              rtmp_7                                  ; 
0805 DC80 C2 30                 USE16BIT 
0806 DC82 20 51 DB     rtmp_8   jsr   discard                  ; disregard everything else
0807 DC85 6B           rtmp_9   rtl   
0808 DC86              ;...............................................................
0809 DC86              ;
0810 DC86              ;  RTMP timer has expired, bridge information no longer valid
0811 DC86              ;...............................................................
0812 DC86              ;
0813 DC86
0814 DC86              RTMPTimer                               ;
0815 DC86 F4 E1 E1 AB           BANK0ENTRY 
0816 DC8B E2 30                 USE8BIT 
0817 DC8D 9C 13 D0              stz   |abridge
0818 DC90 C2 30                 USE16BIT 
0819 DC92 9C 35 D4              stz   |RTMPTmCmd               ; no more RTMP timer
0820 DC95 6B                    rtl   
0821 DC96                       ENDP 
0822 DC96
0823 DC96              ;_______________________________________________________________________________
0824 DC96
0825 DC96              ;...............................................................
0826 DC96              ;
0827 DC96              ;  NBP Name register
0828 DC96              ;...............................................................
0829 DC96              ;
0830 DC96              nbpregname PROC EXPORT 
0831 DC96
0832 DC96                       IS16BIT 
0833 DC96 A0 10 00              ldy   #$10                     ; offset to socket number
0834 DC99 B7 80                 lda   [cmndlist],y
0835 DC9B 20 2A D9              jsr   checkvalidtype           ; see if it is ok
0836 DC9E 90 06                 bcc   @regoksofar              ; no it isn't
0837 DCA0 A9 07 04     @regbadskt lda   #diffsckt              ; bad socket number
0838 DCA3 82 49 00              brl   NBPImdErr                ; exit with error
0839 DCA6              @regoksofar  
0840 DCA6 20 27 DB              jsr   getlisten                ; is socket open ?
0841 DCA9 F0 F5                 beq   @regbadskt               ; socket is not open, so error
0842 DCAB A0 08 00              ldy   #CmEntAdr
0843 DCAE B7 80                 lda   [cmndlist],y
0844 DCB0 18                    clc   
0845 DCB1 69 09 00              adc   #9
0846 DCB4 85 88                 sta   nbpbfptr
0847 DCB6 A0 0A 00              ldy   #CmEntAdr+2
0848 DCB9 B7 80                 lda   [cmndlist],y
0849 DCBB 69 00 00              adc   #0                       ; add in any carry that might have happened
0850 DCBE 85 8A                 sta   nbpbfptr+2
0851 DCC0 20 22 DD              jsr   checkvalidzentity        ; check for all three fields as valid
0852 DCC3 C2 30                 USE16BIT                       ; put back into 16 bit mode
0853 DCC5 90 05                 bcc   checkSetIt               ; name was valid 
0854 DCC7              rgnameisbad                             ; 
0855 DCC7 A9 06 04              lda   #badName
0856 DCCA 80 23                 bra   NBPImdErr
0857 DCCC              checkSetIt                              ; 
0858 DCCC E2 30                 USE8BIT 
0859 DCCE A0 11                 ldy   #CmSetIt
0860 DCD0 B7 80                 lda   [cmndlist],y
0861 DCD2 C2 30                 USE16BIT 
0862 DCD4 F0 0A                 beq   checkfirst
0863 DCD6 20 CF E0              jsr   GetName                  ; see if name already in table
0864 DCD9 D0 0A                 bne   RegFail                  ; yes, so return error
0865 DCDB 20 45 E0              jsr   AddName                  ; don't bother to check
0866 DCDE 80 0F                 bra   NBPImdErr                ; store error that came back from add
0867 DCE0 20 CF E0     checkfirst jsr   GetName                ; is name alreay in table
0868 DCE3 F0 7D                 beq   NBPst1                   ; no then look in net
0869 DCE5 A9 02 04     RegFail  lda   #duplname
0870 DCE8 80 05                 bra   NBPImdErr
0871 DCEA              NBPFail                                 ; 
0872 DCEA C2 30                 USE16BIT 
0873 DCEC A9 08 04              lda   #manyNBP
0874 DCEF A0 02 00     NBPImdErr ldy   #2
0875 DCF2 97 80                 sta   [cmndlist],y
0876 DCF4 4C 13 DE              jmp   chkiocmp
0877 DCF7
0878 DCF7
0879 DCF7              checkvalidname                          ; ;checks to see if the name passed with offset of y
0880 DCF7                       IS8BIT 
0881 DCF7 B7 88                 lda   [nbpbfptr],y             ;get length field
0882 DCF9 F0 06                 beq   nameisbad                ;zero len names not allowed
0883 DCFB C9 21                 cmp   #33                      ;see if too large
0884 DCFD B0 02                 bcs   nameisbad
0885 DCFF 18                    clc                            ;return no error
0886 DD00 60                    rts   
0887 DD01 38           nameisbad sec   
0888 DD02 60                    rts                            ;return with error
0889 DD03
0890 DD03              ;        entry checkvalidentity         ; COMMENTED OUT  **TGH
0891 DD03              checkvalidentity                        ;
0892 DD03 E2 30                 USE8BIT 
0893 DD05 A0 00                 ldy   #0                       ;offset to name field
0894 DD07 20 F7 DC              jsr   checkvalidname           ;see if name is valid
0895 DD0A B0 15                 bcs   checkvaliddone           ;no, so return the error
0896 DD0C A2 01                 ldx   #1                       ;find offset to type field
0897 DD0E A0 00                 ldy   #0
0898 DD10 20 3C E0              jsr   calclng1                 ;find position of type field
0899 DD13 20 F7 DC              jsr   checkvalidname
0900 DD16 B0 09                 bcs   checkvaliddone           ;type is bad
0901 DD18 A2 01                 ldx   #1                       ;find offset to zone field
0902 DD1A 20 3C E0              jsr   calclng1                 ;find position of zone field
0903 DD1D B7 88                 lda   [nbpbfptr],y             ;get length of zone field
0904 DD1F C9 21                 cmp   #33                      ;see if too large (sets carry if it is)
0905 DD21              checkvaliddone                          ; 
0906 DD21 60                    rts                            ;will return with carry set if error
0907 DD22
0908 DD22                       entry checkvalidzentity        ; EXPORT -> ENTRY  **TGH
0909 DD22              checkvalidzentity  
0910 DD22 E2 30                 USE8BIT 
0911 DD24 A0 00                 ldy   #0                       ; points to entity name
0912 DD26 A2 02                 ldx   #2                       ; skip two fileds
0913 DD28 20 3C E0              jsr   calclng1                 ; calulate length of first two fields
0914 DD2B A8                    tay   
0915 DD2C C2 30                 USE16BIT 
0916 DD2E B7 88                 lda   [nbpbfptr],y
0917 DD30 C9 01 2A              cmp   #$2A01                   ; zone must be '*'
0918 DD33 D0 05                 bne   chkvzeisbad              ; it was not '*' so it is bad
0919 DD35 20 03 DD              jsr   checkvalidentity         ;see if entity name is valid
0920 DD38 90 01                 bcc   chkvzereturn             ; name is ok, so no error yet
0921 DD3A 38           chkvzeisbad sec                         ; indicate an error
0922 DD3B              chkvzereturn  
0923 DD3B 60                    rts   
0924 DD3C
0925 DD3C              BadNameErr                              ; 
0926 DD3C C2 30                 USE16BIT 
0927 DD3E A9 06 04              lda   #badName
0928 DD41 80 AC                 bra   NBPImdErr
0929 DD43              ;
0930 DD43              ;...............................................................
0931 DD43              ;
0932 DD43              ;  NBP Name Look Up
0933 DD43              ;...............................................................
0934 DD43              ;
0935 DD43              ;
0936 DD43                       IS16BIT 
0937 DD43
0938 DD43                       EXPORT nbplookup 
0939 DD43              nbplookup                               ;
0940 DD43 A0 17 00              ldy   #CmRspCnt                ; no reply received yet
0941 DD46 80 03                 bra   preNBPsetup              ; call NBP set up and return
0942 DD48              ;
0943 DD48              ;...............................................................
0944 DD48              ;
0945 DD48              ;  NBP Name Confirm
0946 DD48              ;...............................................................
0947 DD48              ;
0948 DD48              ;
0949 DD48                       IS16BIT 
0950 DD48
0951 DD48                       EXPORT nbpconfirm 
0952 DD48              nbpconfirm                              ;
0953 DD48 A0 14 00              ldy   #CmCfmActSkt             ; no socket received
0954 DD4B
0955 DD4B              preNBPsetup                             ; ;come here to set nbpbfptr
0956 DD4B 5A                    phy                            ;save previous offset
0957 DD4C A0 08 00              ldy   #CmEntAdr                ;offset to entity name
0958 DD4F B7 80                 lda   [cmndlist],y             ;get low word
0959 DD51 85 88                 sta   nbpbfptr
0960 DD53 C8                    iny   
0961 DD54 C8                    iny   
0962 DD55 B7 80                 lda   [cmndlist],y             ;get high word
0963 DD57 85 8A                 sta   nbpbfptr+2
0964 DD59 7A                    ply                            ;recover offset and fall through
0965 DD5A              ;
0966 DD5A              ;...............................................................
0967 DD5A              ;
0968 DD5A              ; common routine between LookUp, Confirm and Register
0969 DD5A              ;     they all send out LKUP packets and wait for reply
0970 DD5A              ;...............................................................
0971 DD5A              ;
0972 DD5A              NBPsetup                                ; 
0973 DD5A E2 30                 USE8BIT 
0974 DD5C A9 00                 lda   #0
0975 DD5E 97 80                 sta   [cmndlist],y
0976 DD60 C2 30                 USE16BIT 
0977 DD62              NBPst1                                  ; 
0978 DD62 E2 30                 USE8BIT 
0979 DD64 20 03 DD              jsr   checkvalidentity         ;see if the entity name is valid
0980 DD67 B0 D3                 bcs   BadNameErr               ;no, so leave
0981 DD69 C2 30                 USE16BIT 
0982 DD6B AD 58 D4              lda   |nbpptrsave+1            ; are we still doing another NBP operation ?
0983 DD6E F0 03                 beq   @nbpnottoomuch           ; we are ok
0984 DD70 4C EA DC              jmp   NBPFail                  ; NBP is already in use
0985 DD73              @nbpnottoomuch  
0986 DD73 20 B8 F9              jsr   lforbid                  ; play it safe
0987 DD76 A9 FF 04              lda   #$04FF                   ; make it busy
0988 DD79 A0 02 00              ldy   #2
0989 DD7C 97 80                 sta   [cmndlist],y
0990 DD7E E2 30                 USE8BIT 
0991 DD80 EE 51 D4              inc   |outnbpid
0992 DD83 A0 0D                 ldy   #CmRetry
0993 DD85 B7 80                 lda   [cmndlist],y             ; retry count
0994 DD87 A0 0F                 ldy   #CMTryLft
0995 DD89 97 80                 sta   [cmndlist],y
0996 DD8B 20 2E DE              jsr   NBPquery                 ; make the first query to the network
0997 DD8E C2 30                 USE16BIT 
0998 DD90 A5 80                 lda   cmndlist
0999 DD92 8D 57 D4              sta   |nbpptrsave
1000 DD95 A5 82                 lda   cmndlist+2
1001 DD97 8D 59 D4              sta   |nbpptrsave+2
1002 DD9A 20 E0 F9              jsr   lpermit                  ; done, just wait for result
1003 DD9D 6B                    rtl   
1004 DD9E              ;...............................................................
1005 DD9E              ;
1006 DD9E              ; NBP timeout, maybe time to resend packet or terminate command
1007 DD9E              ; ZP used are those used by dowrtddp
1008 DD9E              ;...............................................................
1009 DD9E              ;
1010 DD9E                       IS16BIT 
1011 DD9E
1012 DD9E              NBPtimeout                              ;
1013 DD9E F4 E1 E1 AB           BANK0ENTRY 
1014 DDA3 C2 20                 USE16M 
1015 DDA5 AD 58 D4              lda   |nbpptrsave+1
1016 DDA8 85 81                 sta   cmndlist+1
1017 DDAA F0 29                 beq   Ntrts                    ; pointer nil, just return
1018 DDAC E2 30                 USE8BIT 
1019 DDAE AD 57 D4              lda   |nbpptrsave
1020 DDB1 85 80                 sta   cmndlist
1021 DDB3
1022 DDB3 C2 30                 USE16BIT 
1023 DDB5 AD 72 D4              lda   |NBPTmCmd+2
1024 DDB8 C9 06 01              cmp   #$0106                   ;timer canceled?
1025 DDBB D0 08                 bne   conttout                 ;branch if not.
1026 DDBD 9C 70 D4              stz   |NBPTmCmd                ;our timer is out.
1027 DDC0 A9 09 04              lda   #NBPaborted
1028 DDC3 80 32                 bra   nbperror
1029 DDC5
1030 DDC5 E2 30        conttout USE8BIT 
1031 DDC7 A0 0F                 ldy   #CMTryLft
1032 DDC9 B7 80                 lda   [cmndlist],y
1033 DDCB F0 0B                 beq   querycmp                 ; all retry has been used, terminate command
1034 DDCD 38                    sec   
1035 DDCE E9 01                 sbc   #1
1036 DDD0 97 80                 sta   [cmndlist],y
1037 DDD2 20 2E DE              jsr   NBPquery                 ; send another LKUP
1038 DDD5              NtRts                                   ; 
1039 DDD5 C2 30                 USE16BIT 
1040 DDD7 6B                    rtl   
1041 DDD8              ; operation completed, request failed if CONFIRM, but succeed if REGISTER
1042 DDD8              ;
1043 DDD8                       IS8BIT 
1044 DDD8 9C 70 D4     querycmp stz   |NBPTmCmd                ; since timer expired, no need to remove it
1045 DDDB 9C 71 D4              stz   |NBPTmCmd+1
1046 DDDE A0 01                 ldy   #1
1047 DDE0 B7 80                 lda   [cmndlist],y
1048 DDE2 C9 10                 cmp   #NBPLKUP                 ; what operation ?
1049 DDE4 C2 30                 USE16BIT 
1050 DDE6 F0 07                 beq   nbpallOK                 ; look up, it is done
1051 DDE8 B0 0A                 bcs   cfrmcmp                  ; confirm, then it has failed
1052 DDEA 20 45 E0              jsr   AddName                  ; register and not duplicate, now we can put it up
1053 DDED 80 08                 bra   nbperror                 ; return error from Add
1054 DDEF A9 00 00     nbpallOK lda   #0
1055 DDF2 80 03                 bra   nbperror
1056 DDF4 A9 03 04     cfrmcmp  lda   #wrongName               ; if to confirm, then it was not confirmed
1057 DDF7
1058 DDF7                       entry nbperror                 ; EXPORT -> ENTRY  **TGH
1059 DDF7              nbperror                                ;       
1060 DDF7 A0 02 00              ldy   #2                       ; return asyn result byte and also set carry
1061 DDFA 97 80                 sta   [cmndlist],y
1062 DDFC 9C 58 D4              stz   |nbpptrsave+1            ; no more ongoing NBP operation
1063 DDFF AD 70 D4              lda   |NBPTmCmd                ; do we still have a timer
1064 DE02 F0 0F                 beq   chkiocmp                 ; if no, then do not remove
1065 DE04 A9 00 05              lda   #RmvTimCmd
1066 DE07 8D 70 D4              sta   |NBPTmCmd                ; command for remove 
1067 DE0A A2 70 D4              ldx   #NBPTmCmd
1068 DE0D A0 E1 00              ldy   #^ramdata
1069 DE10 20 73 E4              jsr   ADispatch
1070 DE13              chkiocmp                                ; 
1071 DE13 A7 80                 lda   [cmndlist]               ;see if async mode
1072 DE15 EB                    xba                            ;we are concerned with the first byte
1073 DE16 EB                    xba                            ;so swap twice to get condition for low byte set
1074 DE17 10 14                 bpl   nocomp                   ;get out, don't do completion
1075 DE19 A0 04 00              ldy   #4
1076 DE1C B7 80                 lda   [cmndlist],y
1077 DE1E 85 84                 sta   execaddr
1078 DE20 C8                    iny   
1079 DE21 C8                    iny   
1080 DE22 B7 80                 lda   [cmndlist],y
1081 DE24 85 86                 sta   execaddr+2
1082 DE26 05 84                 ora   execaddr
1083 DE28 F0 03                 beq   nocomp
1084 DE2A 4C 8A E9              jmp   GoComp                   ; go and execute I/O completion routine
1085 DE2D              nocomp                                  ; 
1086 DE2D 6B                    rtl   
1087 DE2E              ;...............................................................
1088 DE2E              ;
1089 DE2E              ; send out a LKUP packet
1090 DE2E              ;...............................................................
1091 DE2E                       IS8BIT 
1092 DE2E A0 0C        NBPquery ldy   #CmTimOut
1093 DE30 B7 80                 lda   [cmndlist],y
1094 DE32 A0 0E                 ldy   #CmTimLft
1095 DE34 97 80                 sta   [cmndlist],y
1096 DE36 A9 21                 lda   #$21                     ; assume it is LKUP
1097 DE38 8D 50 D4              sta   |outnbp
1098 DE3B A0 01                 ldy   #1
1099 DE3D B7 80                 lda   [cmndlist],y
1100 DE3F C9 11                 cmp   #NBPCFRM
1101 DE41 C2 20                 USE16M 
1102 DE43 F0 15                 beq   nbptim_3                 ; confirm
1103 DE45 9C 46 D4              stz   |nbpdnet                 ; it is just local, zero dest net
1104 DE48 AE 13 D0              ldx   |abridge                 ; do we have a bridge ?
1105 DE4B D0 03                 bne   nbptim2A                 ; yes
1106 DE4D CA                    dex                            ; else broadcast
1107 DE4E 80 05                 bra   nbptim2B
1108 DE50 A0 11        nbptim2A ldy   #$11                     ; go to bridge, command is BRRQ
1109 DE52 8C 50 D4              sty   |outnbp
1110 DE55 8E 48 D4     nbptim2B stx   |nbpdnode                ; destination is bridge or broadcast
1111 DE58 80 0F                 bra   nbptim_4
1112 DE5A A0 10        nbptim_3 ldy   #CmCfmNet
1113 DE5C B7 80                 lda   [cmndlist],y
1114 DE5E 8D 46 D4              sta   |nbpdnet                 ; copy dest net
1115 DE61 A0 12                 ldy   #CmCfmNode
1116 DE63 B7 80                 lda   [cmndlist],y
1117 DE65 A8                    tay   
1118 DE66 8C 48 D4              sty   |nbpdnode                ; destination node
1119 DE69 A0 02        nbptim_4 ldy   #2
1120 DE6B 8C 4B D4              sty   |nbpprot                 ; NBP is type 2
1121 DE6E 8C 4A D4              sty   |nbpssckt                ; from socket 2
1122 DE71 8C 49 D4              sty   |nbpdsckt                ; to socket 2
1123 DE74 8C 55 D4              sty   |nbpentity+3             ; entity socket ; may not be needed
1124 DE77 AD 10 D0              lda   |thisnet
1125 DE7A 8D 52 D4              sta   |nbpentity
1126 DE7D A7 80                 lda   [cmndlist]
1127 DE7F EB                    xba   
1128 DE80 AA                    tax   
1129 DE81 A0 08                 ldy   #CmEntAdr
1130 DE83 B7 80                 lda   [cmndlist],y
1131 DE85 E0 0E                 cpx   #NBPREGN
1132 DE87 D0 05                 bne   nbptim_5
1133 DE89 69 08 00              adc   #8                       ; include carry is plus 9
1134 DE8C 80 01                 bra   nbptim_6                 ; add in any carry
1135 DE8E 18           nbptim_5 clc                            ; if we came here we don't want to add any offset
1136 DE8F 85 88        nbptim_6 sta   nbpbfptr
1137 DE91 8D 69 D4              sta   |entityadr
1138 DE94 A0 0A                 ldy   #CmEntAdr+2
1139 DE96 B7 80                 lda   [cmndlist],y
1140 DE98 69 00 00              adc   #0                       ; add in any carry for bank crossing
1141 DE9B 85 8A                 sta   nbpbfptr+2
1142 DE9D 8D 6B D4              sta   |entityadr+2
1143 DEA0 E2 30                 USE8BIT 
1144 DEA2 A0 00                 ldy   #0
1145 DEA4 20 3A E0              jsr   calcnmln
1146 DEA7 8D 67 D4              sta   |entitylen
1147 DEAA 9C 68 D4              stz   |entitylen+1
1148 DEAD AD 12 D0              lda   |OurNode
1149 DEB0 8D 54 D4              sta   |nbpentity+2
1150 DEB3 9C 56 D4              stz   |nbpentity+4
1151 DEB6 9C 45 D4              stz   |nbpchksmf               ; do not do checksum
1152 DEB9 C2 30                 USE16BIT 
1153 DEBB A9 5B D4              lda   #nbpwds
1154 DEBE 8D 4C D4              sta   |nbpwrtab
1155 DEC1 A9 E1 00              lda   #^ramdata
1156 DEC4 8D 4E D4              sta   |nbpwrtab+2
1157 DEC7 A2 41 D4              ldx   #nbpwrarea-4
1158 DECA A0 E1 00              ldy   #^ramdata
1159 DECD 20 3B D9              jsr   DoWrtDDP
1160 DED0 A0 0C 00              ldy   #CmTimOut
1161 DED3 B7 80                 lda   [cmndlist],y
1162 DED5 29 FF 00              and   #$00FF
1163 DED8 8D 7A D4              sta   |NBPTmTime
1164 DEDB A9 80 04              lda   #InstTimCmd              ; install timer for repeat query and timeout
1165 DEDE 8D 70 D4              sta   |NBPTmCmd
1166 DEE1 A9 9E DD              lda   #NBPTimeout
1167 DEE4 8D 74 D4              sta   |NBPTmTsk
1168 DEE7 A9 FD 00              lda   #^NBPTimeout
1169 DEEA 8D 76 D4              sta   |NBPTmTsk+2
1170 DEED A2 70 D4              ldx   #NBPTmCmd
1171 DEF0 A0 E1 00              ldy   #^ramdata
1172 DEF3 20 73 E4              jsr   ADispatch
1173 DEF6 E2 30                 USE8BIT 
1174 DEF8 60                    rts                            ; OK, done
1175 DEF9                       ENDP 
1176 DEF9
1177 DEF9              ;_______________________________________________________________________________
1178 DEF9
1179 DEF9              ;...............................................................
1180 DEF9              ;
1181 DEF9              ; socket listener for NBP
1182 DEF9              ;...............................................................
1183 DEF9              ;
1184 DEF9                       IS16BIT 
1185 DEF9
1186 DEF9              NBPlisten PROC 
1187 DEF9
1188 DEF9 F4 E1 E1 AB           BANK0ENTRY 
1189 DEFE A2 88 00              ldx   #nbpbfptr
1190 DF01 A9 06 00              lda   #6
1191 DF04 20 4B E5              jsr   saveZP
1192 DF07 E2 30                 USE8BIT 
1193 DF09 A9 02                 lda   #2                       ; NBP has protocol 2
1194 DF0B CD 0F D0              cmp   |ddphead+ldprotocol
1195 DF0E D0 27                 bne   nbplsdone                ; if not, discard it
1196 DF10 C2 30                 USE16BIT 
1197 DF12 AD 14 D0              lda   |tmpNBPPtr
1198 DF15 85 88                 sta   nbpbfptr
1199 DF17 E2 30                 USE8BIT 
1200 DF19 A9 E1                 lda   #^ramdata
1201 DF1B 85 8A                 sta   nbpbfptr+2
1202 DF1D A0 00                 ldy   #0
1203 DF1F B1 88                 lda   (nbpbfptr),y
1204 DF21 AA                    tax   
1205 DF22 29 0F                 and   #$0F
1206 DF24 F0 11                 beq   nbplsdone                ; no tuple, discard it
1207 DF26 8D 6F D4              sta   |tuplect
1208 DF29 8A                    txa   
1209 DF2A 29 F0                 and   #$F0
1210 DF2C C9 30                 cmp   #$30                     ; LKUP-REPLY ?
1211 DF2E F0 16                 beq   ChkReply                 ; then put it into table
1212 DF30 C9 20        nbpls_00 cmp   #$20                     ; LKUP ?
1213 DF32 D0 03                 bne   nbplsdone                ; no, discard it
1214 DF34 20 C7 E1              jsr   NbpReply                 ; lookup our table and reply to it
1215 DF37              nbplsdone                               ; 
1216 DF37 C2 30                 USE16BIT 
1217 DF39 20 51 DB              jsr   discard
1218 DF3C A0 88 00              ldy   #nbpbfptr
1219 DF3F A9 06 00              lda   #6
1220 DF42 20 72 E5              jsr   restoreZP
1221 DF45 6B                    rtl   
1222 DF46              ;
1223 DF46                       IS8BIT 
1224 DF46              ChkReply                                ; 
1225 DF46 C2 30                 USE16BIT 
1226 DF48 AD 58 D4              lda   |nbpptrsave+1            ; are we processing any NBP
1227 DF4B 85 81                 sta   cmndlist+1
1228 DF4D E2 30                 USE8BIT 
1229 DF4F F0 E6                 beq   nbplsdone                ; no, then discard it
1230 DF51 AD 51 D4              lda   |outnbpid
1231 DF54 A0 01                 ldy   #1
1232 DF56 D1 88                 cmp   (nbpbfptr),y             ; is this the one we asked
1233 DF58 D0 DD                 bne   nbplsdone                ; no, then discard it
1234 DF5A AD 57 D4              lda   |nbpptrsave
1235 DF5D 85 80                 sta   cmndlist
1236 DF5F A0 01                 ldy   #1
1237 DF61 B7 80                 lda   [cmndlist],y
1238 DF63 C9 10                 cmp   #NBPLKUP
1239 DF65 F0 29                 beq   nbpls_04                 ; try to add it to user buffer
1240 DF67 B0 07                 bcs   nbpls3A                  ; confirm, then check socket
1241 DF69 C2 30                 USE16BIT 
1242 DF6B A9 02 04              lda   #duplname                ; register name allow no duplicate
1243 DF6E 80 17                 bra   cancellist
1244 DF70                       IS8BIT 
1245 DF70 A0 05        nbpls3A  ldy   #5                       ; confirm, we get a reply, done
1246 DF72 B1 88                 lda   (nbpbfptr),y             ; get actual socket
1247 DF74 A0 14                 ldy   #CmCfmActSkt
1248 DF76 97 80                 sta   [cmndlist],y
1249 DF78 88                    dey   
1250 DF79 D7 80                 cmp   [cmndlist],y             ; did it agree with what we ask for?
1251 DF7B C2 30                 USE16BIT 
1252 DF7D D0 05                 bne   nbpls3B                  ; different socket
1253 DF7F A9 00 00              lda   #0
1254 DF82 80 03                 bra   cancellist               ; everything is OK
1255 DF84 A9 07 04     nbpls3B  lda   #diffsckt                ; confirmed with wrong socket
1256 DF87                       IS16BIT 
1257 DF87 48           cancellist pha   
1258 DF88 22 37 DF FD           jsl   nbplsdone
1259 DF8C 68                    pla   
1260 DF8D 4C F7 DD              jmp   nbperror
1261 DF90              ;
1262 DF90                       IS8BIT 
1263 DF90              nbpls_04                                ; ; name lookup
1264 DF90 C2 30                 USE16BIT 
1265 DF92 18                    clc   
1266 DF93 A5 88                 lda   nbpbfptr
1267 DF95 69 02 00              adc   #2
1268 DF98 85 88                 sta   nbpbfptr                 ; skip to first tuple
1269 DF9A E2 30                 USE8BIT 
1270 DF9C CE 6F D4     nbpls4A  dec   |tuplect
1271 DF9F 30 96                 bmi   nbplsdone                ; all taken care of
1272 DFA1 C2 30                 USE16BIT 
1273 DFA3 A0 12 00              ldy   #CmRsbAdr
1274 DFA6 B7 80                 lda   [cmndlist],y             ; get response buffer and its boundary
1275 DFA8 85 84                 sta   tblptr
1276 DFAA E2 30                 USE8bit 
1277 DFAC A0 14                 ldy   #CmRsbAdr+2
1278 DFAE B7 80                 lda   [cmndlist],y
1279 DFB0 85 86                 sta   tblptr+2
1280 DFB2 A0 17                 ldy   #CmRspCnt                ; get response received, this is current size
1281 DFB4 B7 80                 lda   [cmndlist],y
1282 DFB6 AA                    tax   
1283 DFB7 E8                    inx   
1284 DFB8 86 8C                 stx   nbprcvct
1285 DFBA C6 8C        nbpls_05 dec   nbprcvct
1286 DFBC F0 34                 beq   nbpls_10                 ; not in table
1287 DFBE A0 04                 ldy   #4                       ; check if item is already in table
1288 DFC0              ; here we want to avoid the case when a bridge is turn on and we have a name
1289 DFC0              ; record twice, once with network # 0 and once with network number X, so all
1290 DFC0              ; local net is made to be 0, since this occur very rarely, we may accept
1291 DFC0              ; the error and remove that part
1292 DFC0              ;         USE16M
1293 DFC0              ;         lda (nbpbfptr),y    ; get network number
1294 DFC0              ;         cmp |thisnet
1295 DFC0              ;         bne nbpls_06
1296 DFC0              ;         lda #0
1297 DFC0              ;         sta (nbpbfptr),y    ; local net is same as 0
1298 DFC0              ;         USE8BIT
1299 DFC0              ;
1300 DFC0 B7 84        nbpls_06 lda   [tblptr],y
1301 DFC2 D1 88                 cmp   (nbpbfptr),y
1302 DFC4 D0 11                 bne   nbpls_07                 ; not the same entry
1303 DFC6 88                    dey   
1304 DFC7 10 F7                 bpl   nbpls_06
1305 DFC9 20 38 E0              jsr   calcleng                 ; duplicate, ignore it
1306 DFCC 18           nbpls_6A clc   
1307 DFCD 65 88                 adc   nbpbfptr
1308 DFCF 85 88                 sta   nbpbfptr
1309 DFD1 90 C9                 bcc   nbpls4A
1310 DFD3 E6 89                 inc   nbpbfptr+1
1311 DFD5 80 C5                 bra   nbpls4A
1312 DFD7 A0 05        nbpls_07 ldy   #5                       ; points to entity name
1313 DFD9 A2 03                 ldx   #3                       ; repeat for all three fields
1314 DFDB 38           nbpls_08 sec                            ; add 1 extra
1315 DFDC 98                    tya   
1316 DFDD 77 84                 adc   [tblptr],y               ; add length count
1317 DFDF A8                    tay   
1318 DFE0 CA                    dex   
1319 DFE1 D0 F8                 bne   nbpls_08
1320 DFE3 18                    clc   
1321 DFE4 65 84                 adc   tblptr
1322 DFE6 85 84                 sta   tblptr
1323 DFE8 90 D0                 bcc   nbpls_05
1324 DFEA E6 85                 inc   tblptr+1
1325 DFEC D0 CC                 bne   nbpls_05                 ; second byte not wrapping
1326 DFEE E6 86                 inc   tblptr+2                 ; need to bump third byte
1327 DFF0 80 C8                 bra   nbpls_05                 ; check more from table
1328 DFF2 20 38 E0     nbpls_10 jsr   calcleng                 ; calculate length of name
1329 DFF5 AA                    tax                            ; save it
1330 DFF6 C2 20                 use16M 
1331 DFF8 29 FF 00              and   #$00FF
1332 DFFB 18                    clc   
1333 DFFC 65 84                 adc   tblptr
1334 DFFE 38                    sec   
1335 DFFF A0 12                 ldy   #CmRsbAdr
1336 E001 F7 80                 sbc   [cmndlist],y
1337 E003 A0 10                 ldy   #CmRsbSiz
1338 E005 D7 80                 cmp   [cmndlist],y
1339 E007 E2 30                 use8bit 
1340 E009 F0 02                 beq   nbpls10A                 ; just made it
1341 E00B B0 23                 bcs   noroom                   ; it is buffer full
1342 E00D 9B           nbpls10A txy                            ; size of item
1343 E00E 88           nbpls_11 dey                            ; else copy into table
1344 E00F 30 06                 bmi   nbpls_12
1345 E011 B1 88                 lda   (nbpbfptr),y
1346 E013 97 84                 sta   [tblptr],y
1347 E015 80 F7                 bra   nbpls_11
1348 E017 A0 17        nbpls_12 ldy   #CmRspCnt
1349 E019 18                    clc   
1350 E01A B7 80                 lda   [cmndlist],y             ; increase item count
1351 E01C 69 01                 adc   #1
1352 E01E 97 80                 sta   [cmndlist],y
1353 E020 88                    dey                            ; point to CmMaxRsp
1354 E021 D7 80                 cmp   [cmndlist],y             ; compare number of response
1355 E023 F0 03                 beq   nbpls_13                 ; reach required number
1356 E025 8A                    txa                            ; size of item
1357 E026 80 A4                 bra   nbpls_6A                 ; check more
1358 E028              nbpls_13                                ; 
1359 E028 C2 30                 USE16BIT 
1360 E02A A9 00 00              lda   #0
1361 E02D 4C 87 DF              jmp   cancellist
1362 E030              noroom                                  ; 
1363 E030 C2 30                 USE16BIT 
1364 E032 A9 04 04              lda   #buffull                 ; assume buffer full
1365 E035 4C 87 DF              jmp   cancellist
1366 E038
1367 E038              ;...............................................................
1368 E038              ;
1369 E038              ; calculate length of entity name, has three entry points
1370 E038              ;      calcleng calculate length of name plus address
1371 E038              ;      calcnmln calculate name only, y points to start location
1372 E038              ;      calclng1 then calcalute 1 or 2 fields by setting X and Y
1373 E038              ;      use nbpbfptr to point to buffer
1374 E038              ;      length returns in Acc
1375 E038              ;
1376 E038              ;...............................................................
1377 E038
1378 E038                       IS8BIT 
1379 E038
1380 E038                       entry calcleng                 ; EXPORT -> ENTRY  **TGH
1381 E038 A0 05        calcleng ldy   #5                       ; points to entity name
1382 E03A
1383 E03A                       entry calcnmln                 ; EXPORT -> ENTRY  **TGH
1384 E03A A2 03        calcnmln ldx   #3                       ; repeat for all three fields
1385 E03C
1386 E03C                       entry calclng1                 ; EXPORT -> ENTRY  **TGH
1387 E03C 38           calclng1 sec                            ; add 1 extra
1388 E03D 98                    tya   
1389 E03E 77 88                 adc   [nbpbfptr],y             ; add length count
1390 E040 A8                    tay   
1391 E041 CA                    dex   
1392 E042 D0 F8                 bne   calclng1
1393 E044 60                    rts   
1394 E045
1395 E045              ;...............................................................
1396 E045              ;
1397 E045              ; Add a name to register name link list
1398 E045              ;...............................................................
1399 E045              ;
1400 E045              ;
1401 E045                       IS16BIT 
1402 E045                       entry AddName                  ; EXPORT -> ENTRY  **TGH
1403 E045              AddName                                 ;
1404 E045 20 B8 F9              jsr   lforbid
1405 E048 E2 30                 USE8BIT 
1406 E04A A0 10                 ldy   #CmRegSkt
1407 E04C B7 80                 lda   [cmndlist],y
1408 E04E 85 8C                 sta   regsckt
1409 E050 64 8D                 stz   regenum
1410 E052 C2 20                 USE16M 
1411 E054 A6 8D        AdNam1   ldx   regenum
1412 E056 E8                    inx   
1413 E057 86 8D                 stx   regenum                  ; pick an enumerator
1414 E059 AD 80 D4              lda   |namelist                ; and check the list
1415 E05C 85 84                 sta   tblptr
1416 E05E AD 82 D4              lda   |namelist+2
1417 E061 85 86                 sta   tblptr+2
1418 E063 A5 85        AdNam2   lda   tblptr+1                 ; see if conflict with this one
1419 E065 F0 25                 beq   AdNam5
1420 E067 A0 07                 ldy   #7
1421 E069 B7 84                 lda   [tblptr],y               ; queue element socket+enum
1422 E06B AA                    tax   
1423 E06C E4 8C                 cpx   regsckt                  ; same socket ?
1424 E06E D0 0E                 bne   AdNam4                   ; then no need to worry
1425 E070 A6 8D                 ldx   regenum                  ; have we use it all ?
1426 E072 D0 06                 bne   AdNam3                   ; no, we still have some available
1427 E074 A9 01 04              lda   #toomanynames            ;there are too many names on this socket
1428 E077 82 4F 00              brl   ExitAddName              ;exit with error
1429 E07A              AdNam3                                  ; 
1430 E07A C5 8C                 cmp   regsckt                  ; same enumerator ?
1431 E07C F0 D6                 beq   AdNam1                   ; then try another one
1432 E07E A0 02        AdNam4   ldy   #2                       ; get next queue element
1433 E080 B7 84                 lda   [tblptr],y
1434 E082 48                    pha   
1435 E083 A7 84                 lda   [tblptr]
1436 E085 85 84                 sta   tblptr
1437 E087 68                    pla   
1438 E088 85 86                 sta   tblptr+2
1439 E08A 80 D7                 bra   AdNam2                   ; and keep looking
1440 E08C A0 0A        AdNam5   ldy   #CmEntAdr+2              ; now we can fill the entity address
1441 E08E B7 80                 lda   [cmndlist],y
1442 E090 85 86                 sta   tblptr+2
1443 E092 A0 08                 ldy   #CmEntAdr
1444 E094 B7 80                 lda   [cmndlist],y
1445 E096 85 84                 sta   tblptr
1446 E098 AD 80 D4              lda   |namelist
1447 E09B 87 84                 sta   [tblptr]
1448 E09D AD 82 D4              lda   |namelist+2
1449 E0A0 A0 02                 ldy   #2
1450 E0A2 97 84                 sta   [tblptr],y
1451 E0A4 A5 84                 lda   tblptr
1452 E0A6 8D 80 D4              sta   |namelist
1453 E0A9 A5 86                 lda   tblptr+2
1454 E0AB 8D 82 D4              sta   |namelist+2
1455 E0AE AD 10 D0              lda   |thisnet
1456 E0B1 A0 04                 ldy   #4
1457 E0B3 97 84                 sta   [tblptr],y
1458 E0B5 A5 8C                 lda   regsckt                  ; put socket and enumerator in
1459 E0B7 A0 07                 ldy   #7
1460 E0B9 97 84                 sta   [tblptr],y
1461 E0BB E2 30                 USE8BIT 
1462 E0BD AD 12 D0              lda   |OurNode
1463 E0C0 A0 06                 ldy   #6
1464 E0C2 97 84                 sta   [tblptr],y
1465 E0C4 C2 30                 USE16BIT 
1466 E0C6 A9 00 00              lda   #0                       ; return with no error
1467 E0C9              ExitAddName                             ; 
1468 E0C9 C2 30                 USE16BIT 
1469 E0CB 20 E0 F9              jsr   lpermit
1470 E0CE 60                    rts   
1471 E0CF              ;...............................................................
1472 E0CF              ;
1473 E0CF              ; Check name list for name, exact match only, wild card not used
1474 E0CF              ;     name is point to by nbpbfptr
1475 E0CF              ;     if found in list, point to it by tblptr, else return 0 in tblptr
1476 E0CF              ;...............................................................
1477 E0CF              ;
1478 E0CF              ;
1479 E0CF                       IS16BIT 
1480 E0CF                       entry GetName                  ; EXPORT -> ENTRY  **TGH
1481 E0CF              GetName                                 ;
1482 E0CF E2 30                 USE8BIT 
1483 E0D1 A0 00                 ldy   #0
1484 E0D3 20 3A E0              jsr   calcnmln
1485 E0D6 85 8C                 sta   nameleng
1486 E0D8 C2 30                 USE16BIT 
1487 E0DA AD 80 D4              lda   |namelist
1488 E0DD 85 84                 sta   tblptr
1489 E0DF AD 82 D4              lda   |namelist+2
1490 E0E2 85 86                 sta   tblptr+2
1491 E0E4 A5 85        GetNam_1 lda   tblptr+1
1492 E0E6 F0 69                 beq   GetNam_9
1493 E0E8 18                    clc   
1494 E0E9 A5 84                 lda   tblptr
1495 E0EB 69 09 00              adc   #9
1496 E0EE 85 84                 sta   tblptr                   ; point to entity name
1497 E0F0 A5 86                 lda   tblptr+2                 ; add in high word for bank wrap
1498 E0F2 69 00 00              adc   #0
1499 E0F5 85 86                 sta   tblptr+2
1500 E0F7 E2 30                 USE8BIT 
1501 E0F9 A4 8C        GetNam_2 ldy   nameleng
1502 E0FB 88                    dey   
1503 E0FC B7 84        GetNm2A  lda   [tblptr],y
1504 E0FE C9 61 90 06           UpChar 
1505 E108 85 83                 sta   tempChar
1506 E10A B7 88                 lda   [nbpbfptr],y
1507 E10C C9 61 90 06           UpChar 
1508 E116 C5 83                 cmp   tempChar
1509 E118 D0 18                 bne   GetNam_4                 ; name does not agree
1510 E11A 88                    dey   
1511 E11B 10 DF                 bpl   GetNm2A
1512 E11D C2 30                 USE16BIT 
1513 E11F 38                    sec                            ; name found, point back to entry element
1514 E120 A5 84                 lda   tblptr
1515 E122 E9 09 00              sbc   #9
1516 E125 85 84                 sta   tblptr
1517 E127 A5 86                 lda   tblptr+2                 ; subtract any bank wrap
1518 E129 E9 00 00              sbc   #0
1519 E12C 85 86                 sta   tblptr+2
1520 E12E A9 01 00              lda   #1                       ; set non-zero flag
1521 E131 60                    rts   
1522 E132              GetNam_4                                ; 
1523 E132 C2 30                 USE16BIT 
1524 E134 38                    sec   
1525 E135 A5 84                 lda   tblptr
1526 E137 E9 09 00              sbc   #9
1527 E13A 85 84                 sta   tblptr
1528 E13C A5 86                 lda   tblptr+2                 ; subtract any bank wrap
1529 E13E E9 00 00              sbc   #0
1530 E141 85 86                 sta   tblptr+2
1531 E143 A0 02 00              ldy   #2
1532 E146 B7 84                 lda   [tblptr],y
1533 E148 AA                    tax   
1534 E149 A7 84                 lda   [tblptr]
1535 E14B 85 84                 sta   tblptr
1536 E14D 86 86                 stx   tblptr+2
1537 E14F 80 93                 bra   GetNam_1
1538 E151 60           GetNam_9 rts   
1539 E152              ;...............................................................
1540 E152              ;
1541 E152              ; Remove name from registration
1542 E152              ;...............................................................
1543 E152              ;
1544 E152                       IS16BIT 
1545 E152
1546 E152                       EXPORT nbpremove 
1547 E152              nbpremove                               ;
1548 E152 20 B8 F9              jsr   lforbid
1549 E155 A0 04 00              ldy   #CmRmvEntity
1550 E158 B7 80                 lda   [cmndlist],y
1551 E15A 85 88                 sta   nbpbfptr
1552 E15C A0 06 00              ldy   #CmRmvEntity+2
1553 E15F B7 80                 lda   [cmndlist],y
1554 E161 85 8A                 sta   nbpbfptr+2
1555 E163 20 22 DD              jsr   checkvalidzentity        ; check for all three fields as valid
1556 E166 C2 30                 USE16BIT                       ; put back into 16 bit mode
1557 E168 90 06                 bcc   nbpremovenmvld           ; name is ok, so no error yet
1558 E16A A9 06 04              lda   #badName                 ; the name is bad so return with error
1559 E16D 4C BE E1              jmp   RmvNam_9                 ; show the error
1560 E170              nbpremovenmvld                          ; 
1561 E170 20 CF E0              jsr   GetName
1562 E173 F0 46                 beq   RmvNam_8
1563 E175 AD 80 D4              lda   |namelist
1564 E178 85 88                 sta   nbpbfptr
1565 E17A C5 84                 cmp   tblptr
1566 E17C 08                    php   
1567 E17D AD 82 D4              lda   |namelist+2
1568 E180 85 8A                 sta   nbpbfptr+2
1569 E182 28                    plp   
1570 E183 D0 04                 bne   RmvNam_1                 ; is it the first entry ?
1571 E185 C5 86                 cmp   tblptr+2
1572 E187 F0 20                 beq   RmvNam_4                 ; it is the first entry
1573 E189 A7 88        RmvNam_1 lda   [nbpbfptr]               ; is it the next entry?
1574 E18B AA                    tax   
1575 E18C A0 02 00              ldy   #2
1576 E18F B7 88                 lda   [nbpbfptr],y
1577 E191 C5 86                 cmp   tblptr+2
1578 E193 D0 04                 bne   RmvNam_2
1579 E195 E4 84                 cpx   tblptr
1580 E197 F0 06                 beq   RmvNam_3                 ; yes, it is the next entry
1581 E199 86 88        RmvNam_2 stx   nbpbfptr                 ; not the next, look more in queue
1582 E19B 85 8A                 sta   nbpbfptr+2
1583 E19D 80 EA                 bra   RmvNam_1
1584 E19F A7 84        RmvNam_3 lda   [tblptr]                 ; remove next item from queue
1585 E1A1 87 88                 sta   [nbpbfptr]
1586 E1A3 B7 84                 lda   [tblptr],y
1587 E1A5 97 88                 sta   [nbpbfptr],y
1588 E1A7 80 0D                 bra   RmvNam_5
1589 E1A9 A0 02 00     RmvNam_4 ldy   #2                       ; first name on list, update namelist
1590 E1AC B7 84                 lda   [tblptr],y
1591 E1AE 8D 82 D4              sta   |namelist+2
1592 E1B1 A7 84                 lda   [tblptr]
1593 E1B3 8D 80 D4              sta   |namelist
1594 E1B6 A9 00 00     RmvNam_5 lda   #0
1595 E1B9 80 03                 bra   RmvNam_9
1596 E1BB A9 03 04     RmvNam_8 lda   #wrongname
1597 E1BE A0 02 00     RmvNam_9 ldy   #2
1598 E1C1 97 80                 sta   [cmndlist],y
1599 E1C3 20 E0 F9              jsr   lpermit
1600 E1C6 6B                    rtl   
1601 E1C7              ;...............................................................
1602 E1C7              ;
1603 E1C7              ; Check register list to see if name matches, if it agree, reply to it
1604 E1C7              ;...............................................................
1605 E1C7              ;
1606 E1C7              ;
1607 E1C7                       IS8BIT 
1608 E1C7 A0 01        NbpReply ldy   #1
1609 E1C9 B1 88                 lda   (nbpbfptr),y
1610 E1CB 8D 85 D4              sta   |replyNID
1611 E1CE A0 04                 ldy   #4
1612 E1D0 B1 88                 lda   (nbpbfptr),y             ; request node
1613 E1D2 CD 12 D0              cmp   |OurNode                 ; check if same as ours
1614 E1D5 C2 20                 USE16M 
1615 E1D7 D0 0E                 bne   NbpRp_0                  ; nothing to worry
1616 E1D9 A0 02                 ldy   #2
1617 E1DB B1 88                 lda   (nbpbfptr),y             ; net work number
1618 E1DD F0 05                 beq   ItIsMe                   ; I am the requestor, ignore it
1619 E1DF CD 10 D0              cmp   |thisNet                 ; same net work ?
1620 E1E2 D0 03                 bne   NbpRp_0
1621 E1E4              ItIsMe                                  ; 
1622 E1E4 E2 30                 USE8BIT 
1623 E1E6 60                    rts   
1624 E1E7                       IS16M 
1625 E1E7 20 C2 E2     NbpRp_0  jsr   InitReply
1626 E1EA AD 80 D4              lda   |namelist
1627 E1ED 85 84                 sta   tblptr
1628 E1EF AD 82 D4              lda   |namelist+2
1629 E1F2 85 86                 sta   tblptr+2
1630 E1F4 A5 85        NbpRp_1  lda   tblptr+1
1631 E1F6 F0 7F                 beq   NbpRp_8
1632 E1F8 A0 07                 ldy   #7
1633 E1FA 84 8C                 sty   tempy1
1634 E1FC A0 09                 ldy   #9
1635 E1FE 84 8D                 sty   tempy2
1636 E200 20 CC E2              jsr   CmpItem                  ; does object name agree ?
1637 E203 D0 05                 bne   NbpRp_2                  ; no, 
1638 E205 20 CC E2              jsr   CmpItem                  ; does type agree
1639 E208 F0 0E                 beq   NbpRp_3                  ; yes, then we can reply 
1640 E20A A0 02        NbpRp_2  ldy   #2                       ; no, then check next element
1641 E20C B7 84                 lda   [tblptr],y
1642 E20E 48                    pha   
1643 E20F A7 84                 lda   [tblptr]
1644 E211 85 84                 sta   tblptr
1645 E213 68                    pla   
1646 E214 85 86                 sta   tblptr+2
1647 E216 80 DC                 bra   NbpRp_1
1648 E218 AD 10 D0     NbpRp_3  lda   |thisnet                 ; get latest net number
1649 E21B A0 04                 ldy   #4                       ; in case net number not available earlier
1650 E21D 97 84                 sta   [tblptr],y
1651 E21F                                                      ; 
1652 E21F E2 30                 USE8BIT 
1653 E221 38                    sec                            ; add in field length
1654 E222 A4 8D                 ldy   tempy2
1655 E224 98                    tya   
1656 E225 77 84                 adc   [tblptr],y
1657 E227 38                    sec                            ; find name length
1658 E228 E9 04                 sbc   #4
1659 E22A C2 20                 USE16M 
1660 E22C 29 FF 00              and   #$00FF
1661 E22F A6 8B                 ldx   nbptbdisp
1662 E231 9D 86 D4              sta   |nbprptable,x
1663 E234 E8                    inx   
1664 E235 E8                    inx   
1665 E236 18                    clc   
1666 E237 A5 84                 lda   tblptr
1667 E239 69 04 00              adc   #4
1668 E23C 9D 86 D4              sta   |nbprptable,x
1669 E23F E8                    inx   
1670 E240 E8                    inx   
1671 E241 A5 86                 lda   tblptr+2
1672 E243 69 00 00              adc   #0                       ; add in for bank wrap
1673 E246 9D 86 D4              sta   |nbprptable,x
1674 E249 E8                    inx   
1675 E24A E8                    inx   
1676 E24B 86 8B                 stx   nbptbdisp
1677 E24D AC 84 D4              ldy   |rptupcount
1678 E250 C8                    iny   
1679 E251 8C 84 D4              sty   |rptupcount
1680 E254 C0 04                 cpy   #4
1681 E256 D0 B2                 bne   NbpRp_2                  ; go and check more
1682 E258 C2 30                 USE16BIT 
1683 E25A A2 84 00              ldx   #tblptr                  ; clobbered so save it first
1684 E25D A9 07 00              lda   #7
1685 E260 20 4B E5              jsr   saveZP
1686 E263 E2 10                 _16BIT16M 
1687 E265 20 82 E2              jsr   DoNbpReply               ; table filled, write it out
1688 E268 C2 30                 USE16BIT 
1689 E26A A0 84 00              ldy   #tblptr
1690 E26D A9 07 00              lda   #7
1691 E270 20 72 E5              jsr   restoreZP
1692 E273 E2 10                 _16BIT16M 
1693 E275 80 93                 bra   NbpRp_2
1694 E277 AE 84 D4     NbpRp_8  ldx   |rptupcount              ; do we have any matches
1695 E27A F0 03                 beq   NbpRp_9                  ; no
1696 E27C 20 82 E2              jsr   DoNbpReply               ; else write it out
1697 E27F              NbpRp_9                                 ; 
1698 E27F E2 30                 USE8BIT 
1699 E281 60                    rts   
1700 E282              ;...............................................................
1701 E282              ;
1702 E282              ; do the actual reply
1703 E282              ;...............................................................
1704 E282              ;
1705 E282              ;
1706 E282                       IS16M 
1707 E282 A9 FF FF     DoNbpReply lda   #$FFFF
1708 E285 A6 8B                 ldx   nbptbdisp
1709 E287 9D 86 D4              sta   |nbprptable,x            ; end of table marker
1710 E28A A0 02                 ldy   #2
1711 E28C B1 88                 lda   (nbpbfptr),y             ; dest network
1712 E28E 8D 46 D4              sta   |nbpdnet
1713 E291 A0 04                 ldy   #4
1714 E293 B1 88                 lda   (nbpbfptr),y             ; dest node and socket
1715 E295 8D 48 D4              sta   |nbpdnode
1716 E298 E2 30                 USE8BIT 
1717 E29A 9C 45 D4              stz   |nbpchksmf
1718 E29D AD 84 D4              lda   |rptupcount
1719 E2A0 09 30                 ora   #$30                     ; a LkUp-reply tuple
1720 E2A2 8D 84 D4              sta   |rptupcount
1721 E2A5 C2 30                 USE16BIT 
1722 E2A7 A9 86 D4              lda   #nbprptable
1723 E2AA 8D 4C D4              sta   |nbpwrtab
1724 E2AD A9 E1 00              lda   #^ramdata
1725 E2B0 8D 4E D4              sta   |nbpwrtab+2
1726 E2B3 A2 41 D4              ldx   #nbpwrarea-4
1727 E2B6 A0 E1 00              ldy   #^ramdata
1728 E2B9 20 3B D9              jsr   DoWrtDDP                 ; reply to it, ignore any error
1729 E2BC E2 10                 _16BIT16M 
1730 E2BE 20 C2 E2              jsr   InitReply
1731 E2C1 60                    rts   
1732 E2C2              ;
1733 E2C2                       IS16M 
1734 E2C2              InitReply                               ; 
1735 E2C2 A2 0C                 ldx   #12
1736 E2C4 86 8B                 stx   nbptbdisp
1737 E2C6 A2 00                 ldx   #0
1738 E2C8 8E 84 D4              stx   |rptupcount
1739 E2CB 60                    rts   
1740 E2CC              ;...............................................................
1741 E2CC              ;
1742 E2CC              ; compare item to see if it matches, wildcard is used
1743 E2CC              ;...............................................................
1744 E2CC              ;
1745 E2CC              ; 
1746 E2CC                       IS16M 
1747 E2CC              CmpItem                                 ; 
1748 E2CC A4 8C                 ldy   tempy1
1749 E2CE B1 88                 lda   (nbpbfptr),y
1750 E2D0 C9 01 3D              cmp   #$3D01                   ; '='
1751 E2D3 F0 31                 beq   CmpItm_3
1752 E2D5 E2 30                 USE8BIT 
1753 E2D7 AA                    tax   
1754 E2D8 A4 8C        CmpItm_1 ldy   tempy1
1755 E2DA E6 8C                 inc   tempy1
1756 E2DC B1 88                 lda   (nbpbfptr),y
1757 E2DE C9 61 90 06           UpChar 
1758 E2E8 85 83                 sta   tempChar
1759 E2EA A4 8D                 ldy   tempy2
1760 E2EC E6 8D                 inc   tempy2
1761 E2EE B7 84                 lda   [tblptr],y
1762 E2F0 C9 61 90 06           UpChar 
1763 E2FA C5 83                 cmp   tempChar
1764 E2FC D0 05                 bne   CmpItm_2
1765 E2FE CA                    dex   
1766 E2FF 10 D7                 bpl   CmpItm_1
1767 E301 E2 02                 sep   #2                       ; set z flag
1768 E303              CmpItm_2                                ; 
1769 E303 C2 20                 USE16M 
1770 E305 60                    rts   
1771 E306 C8           CmpItm_3 iny                            ; skip over '='
1772 E307 C8                    iny   
1773 E308 84 8C                 sty   tempy1
1774 E30A A4 8D                 ldy   tempy2
1775 E30C E2 30                 USE8BIT 
1776 E30E B7 84                 lda   [tblptr],y
1777 E310 38                    sec   
1778 E311 65 8D                 adc   tempy2
1779 E313 85 8D                 sta   tempy2
1780 E315 E2 02                 sep   #2                       ; set z flag
1781 E317 C2 20                 USE16M 
1782 E319 60                    rts   
1783 E31A              ;
1784 E31A                       ENDP 
1785 E31A
1786 E31A              nbpkill  PROC EXPORT
1787 E31A
1788 E31A                       IS16BIT 
1789 E31A
1790 E31A A0 04 00              ldy   #4
1791 E31D B7 80                 lda   [cmndlist],y
1792 E31F CD 57 D4              cmp   |nbpptrsave
1793 E322 D0 09                 bne   badexit
1794 E324 C8                    iny   
1795 E325 C8                    iny   
1796 E326 B7 80                 lda   [cmndlist],y
1797 E328 CD 59 D4              cmp   |nbpptrsave+2
1798 E32B F0 05                 beq   goodpb
1799 E32D
1800 E32D A9 0A 04     badexit  lda   #BadParamBlock
1801 E330 80 21                 bra   exit
1802 E332
1803 E332 AD 70 D4     goodpb   lda   |nbptmcmd
1804 E335 F0 19                 beq   justleave
1805 E337
1806 E337 D4 80                 pei   cmndlist
1807 E339 D4 82                 pei   cmndlist+2
1808 E33B
1809 E33B A9 00 45              lda   #CnclTmCmd
1810 E33E 8D 70 D4              sta   |nbptmcmd
1811 E341 A2 70 D4              ldx   #nbptmcmd
1812 E344 A0 E1 00              ldy   #^ramdata
1813 E347 20 73 E4              jsr   ADispatch
1814 E34A
1815 E34A 68                    pla   
1816 E34B 85 82                 sta   cmndlist+2
1817 E34D 68                    pla   
1818 E34E 85 80                 sta   cmndlist
1819 E350
1820 E350 A9 00 00     justleave lda   #0
1821 E353 A0 02 00     exit     ldy   #2
1822 E356 97 80                 sta   [cmndlist],y
1823 E358 6B                    rtl   
1824 E359
1825 E359                       ENDP 
1826 E359
1827 E359              ;_______________________________________________________________________________
1828 E359
1829 E359              DDPInit  PROC EXPORT 
1830 E359
1831 E359                       IS16BIT 
1832 E359 9C 00 D0              stz   |lapdest                 ; clear to zero
1833 E35C A2 00 D0              ldx   #lapdest
1834 E35F A0 01 D0              ldy   #lapdest+1
1835 E362 A9 AA 04              lda   #NBPEnd-lapdest-2
1836 E365 54 E1 E1              mvn   ramdata,ramdata
1837 E368 E2 30                 USE8BIT 
1838 E36A A0 09                 ldy   #9                       ; findout node number
1839 E36C B7 80                 lda   [cmndlist],y
1840 E36E 8D 12 D0              sta   |ourNode
1841 E371 C2 30                 USE16BIT 
1842 E373 A9 07 00              lda   #7                       ; initialize nbpwds
1843 E376 8D 61 D4              sta   |nbpwds+6
1844 E379 A9 50 D4              lda   #outnbp
1845 E37C 8D 63 D4              sta   |nbpwds+8
1846 E37F A9 E1 00              lda   #^ramdata
1847 E382 8D 65 D4              sta   |nbpwds+10
1848 E385 A9 FF FF              lda   #$FFFF
1849 E388 8D 6D D4              sta   |nbpwdsend
1850 E38B A9 02 00              lda   #2
1851 E38E 8D 8C D4              sta   |nbprptable+6
1852 E391 A9 84 D4              lda   #rptupcount
1853 E394 8D 8E D4              sta   |nbprptable+8
1854 E397 A9 E1 00              lda   #^ramdata
1855 E39A 8D 90 D4              sta   |nbprptable+10
1856 E39D A9 01 00              lda   #1                       ; install short DDP handler
1857 E3A0 A2 58 DB              ldx   #ShortDDP
1858 E3A3 A0 FD 00              ldy   #^ShortDDP
1859 E3A6 38                    sec   
1860 E3A7 20 F7 F6              jsr   lattachprot
1861 E3AA A9 02 00              lda   #2                       ; install long DDP handler
1862 E3AD A2 9F DB              ldx   #LongDDP
1863 E3B0 A0 FD 00              ldy   #^LongDDP
1864 E3B3 38                    sec   
1865 E3B4 20 F7 F6              jsr   lattachprot
1866 E3B7 A2 D3 E3              ldx   #OpenRTMP                ; install RTMP listener
1867 E3BA A0 FD 00              ldy   #^OpenRTMP
1868 E3BD 20 73 E4              jsr   ADispatch
1869 E3C0 A2 DC E3              ldx   #OPENNBP                 ; install NBP listener
1870 E3C3 A0 FD 00              ldy   #^OPENNBP
1871 E3C6 20 73 E4              jsr   ADispatch
1872 E3C9 A2 E5 E3              ldx   #RTMPreq                 ; do RTMP request
1873 E3CC A0 FD 00              ldy   #^RTMPreq
1874 E3CF 20 73 E4              jsr   ADispatch
1875 E3D2 60                    rts   
1876 E3D3              ;
1877 E3D3              ;
1878 E3D3 00 0B        OpenRTMP DC W:OpnSktCmd
1879 E3D5 00 00                 DC W:0
1880 E3D7 01                    DC B:1
1881 E3D8 28 DC FD 00           DC L:RTMPListen
1882 E3DC 00 0B        OpenNBP  DC W:OpnSktCmd
1883 E3DE 00 00                 DC W:0
1884 E3E0 02                    DC B:2
1885 E3E1 F9 DE FD 00           DC L:NBPListen
1886 E3E5 00 07        RTMPReq  DC W:LapWrtCmd
1887 E3E7 00 00                 DC W:0
1888 E3E9 FF                    DC B:$FF                       ; broadcast
1889 E3EA 01                    DC B:1                         ; short DDP
1890 E3EB EF E3 FD 00           DC L:RTMPBDS
1891 E3EF 06 00        RTMPBDS  DC W:6                         ; 6 byte header
1892 E3F1 F7 E3 FD 00           DC L:RTMPhead
1893 E3F5 FF FF                 DC W:$FFFF                     ; end of table
1894 E3F7 00 06        RTMPhead DC B:0,6                       ; header length
1895 E3F9 01                    DC B:1                         ; to socket 1
1896 E3FA 01                    DC B:1                         ; from socket 1
1897 E3FB 05                    DC B:5                         ; prototype 5
1898 E3FC 01                    DC B:1                         ; command 1
1899 E3FD                       ENDP 
1900 E3FD
1901 E3FD              ;_______________________________________________________________________________
1902 E3FD
1903 E3FD                       END   
